# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------
from .._serialization import Serializer, Deserializer
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, IO, Optional, Union

from azure.core.async_paging import AsyncItemPaged

from .. import models as _models

JSON = MutableMapping[str, Any]


class WebSiteManagementClientOperationsMixin(object):

    async def check_name_availability(
        self,
        name: str,
        type: Union[str, _models.CheckNameResourceTypes],
        is_fqdn: Optional[bool] = None,
        environment_id: Optional[str] = None,
        **kwargs: Any
    ) -> _models.ResourceNameAvailability:
        """Check if a resource name is available.

        Description for Check if a resource name is available.

        :param name: Resource name to verify. Required.
        :type name: str
        :param type: Resource type used for verification. Known values are: "Site", "Slot",
         "HostingEnvironment", "PublishingUser", "Microsoft.Web/sites", "Microsoft.Web/sites/slots",
         "Microsoft.Web/hostingEnvironments", and "Microsoft.Web/publishingUsers". Required.
        :type type: str or ~azure.mgmt.web.v2024_11_01.models.CheckNameResourceTypes
        :param is_fqdn: Is fully qualified domain name. Default value is None.
        :type is_fqdn: bool
        :param environment_id: Azure Resource Manager ID of the customer's selected Container Apps
         Environment on which to host the Function app. This must be of the form
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.App/managedEnvironments/{managedEnvironmentName}.
         Default value is None.
        :type environment_id: str
        :return: ResourceNameAvailability or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_11_01.models.ResourceNameAvailability
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version("check_name_availability")
        if api_version == "2016-03-01":
            from ..v2016_03_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2018-02-01":
            from ..v2018_02_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2022-09-01":
            from ..v2022_09_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2023-01-01":
            from ..v2023_01_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2024-11-01":
            from ..v2024_11_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'check_name_availability'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.check_name_availability(name, type, is_fqdn, environment_id, **kwargs)

    async def get_publishing_user(self, **kwargs: Any) -> _models.User:
        """Gets publishing user.

        Description for Gets publishing user.

        :return: User or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_11_01.models.User
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version("get_publishing_user")
        if api_version == "2016-03-01":
            from ..v2016_03_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2018-02-01":
            from ..v2018_02_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2022-09-01":
            from ..v2022_09_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2023-01-01":
            from ..v2023_01_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2024-11-01":
            from ..v2024_11_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_publishing_user'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.get_publishing_user(**kwargs)

    async def get_source_control(self, source_control_type: str, **kwargs: Any) -> _models.SourceControl:
        """Gets source control token.

        Description for Gets source control token.

        :param source_control_type: Type of source control. Required.
        :type source_control_type: str
        :return: SourceControl or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_11_01.models.SourceControl
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version("get_source_control")
        if api_version == "2016-03-01":
            from ..v2016_03_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2018-02-01":
            from ..v2018_02_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2022-09-01":
            from ..v2022_09_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2023-01-01":
            from ..v2023_01_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2024-11-01":
            from ..v2024_11_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_source_control'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.get_source_control(source_control_type, **kwargs)

    async def get_subscription_deployment_locations(self, **kwargs: Any) -> _models.DeploymentLocations:
        """Gets list of available geo regions plus ministamps.

        Description for Gets list of available geo regions plus ministamps.

        :return: DeploymentLocations or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_11_01.models.DeploymentLocations
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version("get_subscription_deployment_locations")
        if api_version == "2016-03-01":
            from ..v2016_03_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2018-02-01":
            from ..v2018_02_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2022-09-01":
            from ..v2022_09_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2023-01-01":
            from ..v2023_01_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2024-11-01":
            from ..v2024_11_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError(
                "API version {} does not have operation 'get_subscription_deployment_locations'".format(api_version)
            )
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.get_subscription_deployment_locations(**kwargs)

    def list_ase_regions(self, **kwargs: Any) -> AsyncItemPaged["_models.AseRegion"]:
        """Get a list of available ASE regions and its supported Skus.

        Description for get a list of available ASE regions and its supported Skus.

        :return: An iterator like instance of either AseRegion or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_11_01.models.AseRegion]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version("list_ase_regions")
        if api_version == "2023-01-01":
            from ..v2023_01_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2024-11-01":
            from ..v2024_11_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_ase_regions'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_ase_regions(**kwargs)

    def list_billing_meters(
        self, billing_location: Optional[str] = None, os_type: Optional[str] = None, **kwargs: Any
    ) -> AsyncItemPaged["_models.BillingMeter"]:
        """Gets a list of meters for a given location.

        Description for Gets a list of meters for a given location.

        :param billing_location: Azure Location of billable resource. Default value is None.
        :type billing_location: str
        :param os_type: App Service OS type meters used for. Default value is None.
        :type os_type: str
        :return: An iterator like instance of either BillingMeter or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_11_01.models.BillingMeter]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version("list_billing_meters")
        if api_version == "2018-02-01":
            from ..v2018_02_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2022-09-01":
            from ..v2022_09_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2023-01-01":
            from ..v2023_01_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2024-11-01":
            from ..v2024_11_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_billing_meters'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_billing_meters(billing_location, os_type, **kwargs)

    def list_custom_host_name_sites(
        self, hostname: Optional[str] = None, **kwargs: Any
    ) -> AsyncItemPaged["_models.CustomHostnameSites"]:
        """Get custom hostnames under this subscription.

        Get custom hostnames under this subscription.

        :param hostname: Specific hostname. Default value is None.
        :type hostname: str
        :return: An iterator like instance of either CustomHostnameSites or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_11_01.models.CustomHostnameSites]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version("list_custom_host_name_sites")
        if api_version == "2022-09-01":
            from ..v2022_09_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2023-01-01":
            from ..v2023_01_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2024-11-01":
            from ..v2024_11_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_custom_host_name_sites'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_custom_host_name_sites(hostname, **kwargs)

    def list_geo_regions(
        self,
        sku: Optional[Union[str, _models.SkuName]] = None,
        linux_workers_enabled: Optional[bool] = None,
        xenon_workers_enabled: Optional[bool] = None,
        linux_dynamic_workers_enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.GeoRegion"]:
        """Get a list of available geographical regions.

        Description for Get a list of available geographical regions.

        :param sku: Name of SKU used to filter the regions. Known values are: "Free", "Shared",
         "Basic", "Standard", "Premium", "Dynamic", "Isolated", "IsolatedV2", "PremiumV2", "PremiumV3",
         "PremiumContainer", "ElasticPremium", "ElasticIsolated", and "FlexConsumption". Default value
         is None.
        :type sku: str or ~azure.mgmt.web.v2024_11_01.models.SkuName
        :param linux_workers_enabled: Specify :code:`<code>true</code>` if you want to filter to only
         regions that support Linux workers. Default value is None.
        :type linux_workers_enabled: bool
        :param xenon_workers_enabled: Specify :code:`<code>true</code>` if you want to filter to only
         regions that support Xenon workers. Default value is None.
        :type xenon_workers_enabled: bool
        :param linux_dynamic_workers_enabled: Specify :code:`<code>true</code>` if you want to filter
         to only regions that support Linux Consumption Workers. Default value is None.
        :type linux_dynamic_workers_enabled: bool
        :return: An iterator like instance of either GeoRegion or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_11_01.models.GeoRegion]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version("list_geo_regions")
        if api_version == "2016-03-01":
            from ..v2016_03_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2018-02-01":
            from ..v2018_02_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2022-09-01":
            from ..v2022_09_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2023-01-01":
            from ..v2023_01_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2024-11-01":
            from ..v2024_11_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_geo_regions'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_geo_regions(
            sku, linux_workers_enabled, xenon_workers_enabled, linux_dynamic_workers_enabled, **kwargs
        )

    def list_premier_add_on_offers(self, **kwargs: Any) -> AsyncItemPaged["_models.PremierAddOnOffer"]:
        """List all premier add-on offers.

        Description for List all premier add-on offers.

        :return: An iterator like instance of either PremierAddOnOffer or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_11_01.models.PremierAddOnOffer]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version("list_premier_add_on_offers")
        if api_version == "2016-03-01":
            from ..v2016_03_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2018-02-01":
            from ..v2018_02_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2022-09-01":
            from ..v2022_09_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2023-01-01":
            from ..v2023_01_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2024-11-01":
            from ..v2024_11_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_premier_add_on_offers'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_premier_add_on_offers(**kwargs)

    def list_site_identifiers_assigned_to_host_name(  # pylint: disable=name-too-long
        self, name_identifier: Union[_models.NameIdentifier, IO[bytes]], **kwargs: Any
    ) -> AsyncItemPaged["_models.Identifier"]:
        """List all apps that are assigned to a hostname.

        Description for List all apps that are assigned to a hostname.

        :param name_identifier: Hostname information. Is either a NameIdentifier type or a IO[bytes]
         type. Required.
        :type name_identifier: ~azure.mgmt.web.v2024_11_01.models.NameIdentifier or IO[bytes]
        :return: An iterator like instance of either Identifier or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_11_01.models.Identifier]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version("list_site_identifiers_assigned_to_host_name")
        if api_version == "2016-03-01":
            from ..v2016_03_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2018-02-01":
            from ..v2018_02_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2022-09-01":
            from ..v2022_09_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2023-01-01":
            from ..v2023_01_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2024-11-01":
            from ..v2024_11_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError(
                "API version {} does not have operation 'list_site_identifiers_assigned_to_host_name'".format(
                    api_version
                )
            )
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_site_identifiers_assigned_to_host_name(name_identifier, **kwargs)

    async def list_skus(self, **kwargs: Any) -> _models.SkuInfos:
        """List all SKUs.

        Description for List all SKUs.

        :return: SkuInfos or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_11_01.models.SkuInfos
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version("list_skus")
        if api_version == "2016-03-01":
            from ..v2016_03_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2018-02-01":
            from ..v2018_02_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2022-09-01":
            from ..v2022_09_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2023-01-01":
            from ..v2023_01_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2024-11-01":
            from ..v2024_11_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_skus'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.list_skus(**kwargs)

    def list_source_controls(self, **kwargs: Any) -> AsyncItemPaged["_models.SourceControl"]:
        """Gets the source controls available for Azure websites.

        Description for Gets the source controls available for Azure websites.

        :return: An iterator like instance of either SourceControl or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_11_01.models.SourceControl]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version("list_source_controls")
        if api_version == "2016-03-01":
            from ..v2016_03_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2018-02-01":
            from ..v2018_02_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2022-09-01":
            from ..v2022_09_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2023-01-01":
            from ..v2023_01_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2024-11-01":
            from ..v2024_11_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_source_controls'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_source_controls(**kwargs)

    async def move(
        self,
        resource_group_name: str,
        move_resource_envelope: Union[_models.CsmMoveResourceEnvelope, IO[bytes]],
        **kwargs: Any
    ) -> None:
        """Move resources between resource groups.

        Description for Move resources between resource groups.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param move_resource_envelope: Object that represents the resource to move. Is either a
         CsmMoveResourceEnvelope type or a IO[bytes] type. Required.
        :type move_resource_envelope: ~azure.mgmt.web.v2024_11_01.models.CsmMoveResourceEnvelope or
         IO[bytes]
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version("move")
        if api_version == "2016-03-01":
            from ..v2016_03_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2018-02-01":
            from ..v2018_02_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2022-09-01":
            from ..v2022_09_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2023-01-01":
            from ..v2023_01_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2024-11-01":
            from ..v2024_11_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'move'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.move(resource_group_name, move_resource_envelope, **kwargs)

    async def regional_check_name_availability(
        self,
        location: str,
        name: str,
        type: Union[str, _models.CheckNameResourceTypes],
        resource_group_name: Optional[str] = None,
        auto_generated_domain_name_label_scope: Optional[str] = None,
        **kwargs: Any
    ) -> _models.DnlResourceNameAvailability:
        """Check if a resource name is available for DNL sites.

        Check if a resource name is available for DNL sites.

        :param location: Required.
        :type location: str
        :param name: Resource name to verify. Required.
        :type name: str
        :param type: Resource type used for verification. Known values are: "Site", "Slot",
         "HostingEnvironment", "PublishingUser", "Microsoft.Web/sites", "Microsoft.Web/sites/slots",
         "Microsoft.Web/hostingEnvironments", and "Microsoft.Web/publishingUsers". Required.
        :type type: str or ~azure.mgmt.web.v2024_11_01.models.CheckNameResourceTypes
        :param resource_group_name: Resource group name. Default value is None.
        :type resource_group_name: str
        :param auto_generated_domain_name_label_scope: Indicates the endpoint name reuse scope.The
         default value is TenantReuse.
         Supported values are TenantReuse, SubscriptionReuse, ResourceGroupReuse, NoReuse. Default
         value is None.
        :type auto_generated_domain_name_label_scope: str
        :return: DnlResourceNameAvailability or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_11_01.models.DnlResourceNameAvailability
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version("regional_check_name_availability")
        if api_version == "2024-11-01":
            from ..v2024_11_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError(
                "API version {} does not have operation 'regional_check_name_availability'".format(api_version)
            )
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.regional_check_name_availability(
            location, name, type, resource_group_name, auto_generated_domain_name_label_scope, **kwargs
        )

    async def update_publishing_user(self, user_details: Union[_models.User, IO[bytes]], **kwargs: Any) -> _models.User:
        """Updates publishing user.

        Description for Updates publishing user.

        :param user_details: Details of publishing user. Is either a User type or a IO[bytes] type.
         Required.
        :type user_details: ~azure.mgmt.web.v2024_11_01.models.User or IO[bytes]
        :return: User or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_11_01.models.User
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version("update_publishing_user")
        if api_version == "2016-03-01":
            from ..v2016_03_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2018-02-01":
            from ..v2018_02_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2022-09-01":
            from ..v2022_09_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2023-01-01":
            from ..v2023_01_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2024-11-01":
            from ..v2024_11_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'update_publishing_user'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.update_publishing_user(user_details, **kwargs)

    async def update_source_control(
        self, source_control_type: str, request_message: Union[_models.SourceControl, IO[bytes]], **kwargs: Any
    ) -> _models.SourceControl:
        """Updates source control token.

        Description for Updates source control token.

        :param source_control_type: Type of source control. Required.
        :type source_control_type: str
        :param request_message: Source control token information. Is either a SourceControl type or a
         IO[bytes] type. Required.
        :type request_message: ~azure.mgmt.web.v2024_11_01.models.SourceControl or IO[bytes]
        :return: SourceControl or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_11_01.models.SourceControl
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version("update_source_control")
        if api_version == "2016-03-01":
            from ..v2016_03_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2018-02-01":
            from ..v2018_02_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2022-09-01":
            from ..v2022_09_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2023-01-01":
            from ..v2023_01_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2024-11-01":
            from ..v2024_11_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'update_source_control'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.update_source_control(source_control_type, request_message, **kwargs)

    async def validate(
        self, resource_group_name: str, validate_request: Union[_models.ValidateRequest, IO[bytes]], **kwargs: Any
    ) -> _models.ValidateResponse:
        """Validate if a resource can be created.

        Description for Validate if a resource can be created.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param validate_request: Request with the resources to validate. Is either a ValidateRequest
         type or a IO[bytes] type. Required.
        :type validate_request: ~azure.mgmt.web.v2024_11_01.models.ValidateRequest or IO[bytes]
        :return: ValidateResponse or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_11_01.models.ValidateResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version("validate")
        if api_version == "2016-03-01":
            from ..v2016_03_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2018-02-01":
            from ..v2018_02_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2022-09-01":
            from ..v2022_09_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2023-01-01":
            from ..v2023_01_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2024-11-01":
            from ..v2024_11_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'validate'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.validate(resource_group_name, validate_request, **kwargs)

    async def validate_container_settings(
        self,
        resource_group_name: str,
        validate_container_settings_request: Union[_models.ValidateContainerSettingsRequest, IO[bytes]],
        **kwargs: Any
    ) -> JSON:
        """Validate if the container settings are correct.

        Validate if the container settings are correct.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param validate_container_settings_request: Is either a ValidateContainerSettingsRequest type
         or a IO[bytes] type. Required.
        :type validate_container_settings_request:
         ~azure.mgmt.web.v2018_02_01.models.ValidateContainerSettingsRequest or IO[bytes]
        :return: JSON or the result of cls(response)
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version("validate_container_settings")
        if api_version == "2018-02-01":
            from ..v2018_02_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'validate_container_settings'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.validate_container_settings(
            resource_group_name, validate_container_settings_request, **kwargs
        )

    async def validate_move(
        self,
        resource_group_name: str,
        move_resource_envelope: Union[_models.CsmMoveResourceEnvelope, IO[bytes]],
        **kwargs: Any
    ) -> None:
        """Validate whether a resource can be moved.

        Description for Validate whether a resource can be moved.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param move_resource_envelope: Object that represents the resource to move. Is either a
         CsmMoveResourceEnvelope type or a IO[bytes] type. Required.
        :type move_resource_envelope: ~azure.mgmt.web.v2024_11_01.models.CsmMoveResourceEnvelope or
         IO[bytes]
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version("validate_move")
        if api_version == "2016-03-01":
            from ..v2016_03_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2018-02-01":
            from ..v2018_02_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2022-09-01":
            from ..v2022_09_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2023-01-01":
            from ..v2023_01_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2024-11-01":
            from ..v2024_11_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'validate_move'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.validate_move(resource_group_name, move_resource_envelope, **kwargs)

    async def verify_hosting_environment_vnet(
        self, parameters: Union[_models.VnetParameters, IO[bytes]], **kwargs: Any
    ) -> _models.VnetValidationFailureDetails:
        """Verifies if this VNET is compatible with an App Service Environment by analyzing the Network
        Security Group rules.

        Description for Verifies if this VNET is compatible with an App Service Environment by
        analyzing the Network Security Group rules.

        :param parameters: VNET information. Is either a VnetParameters type or a IO[bytes] type.
         Required.
        :type parameters: ~azure.mgmt.web.v2024_11_01.models.VnetParameters or IO[bytes]
        :return: VnetValidationFailureDetails or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_11_01.models.VnetValidationFailureDetails
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version("verify_hosting_environment_vnet")
        if api_version == "2016-03-01":
            from ..v2016_03_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2018-02-01":
            from ..v2018_02_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2022-09-01":
            from ..v2022_09_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2023-01-01":
            from ..v2023_01_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == "2024-11-01":
            from ..v2024_11_01.aio.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError(
                "API version {} does not have operation 'verify_hosting_environment_vnet'".format(api_version)
            )
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._config.api_version = api_version
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return await mixin_instance.verify_hosting_environment_vnet(parameters, **kwargs)
