﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ssm/SSM_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SSM {
namespace Model {
class UpdateMaintenanceWindowResult {
 public:
  AWS_SSM_API UpdateMaintenanceWindowResult() = default;
  AWS_SSM_API UpdateMaintenanceWindowResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SSM_API UpdateMaintenanceWindowResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ID of the created maintenance window.</p>
   */
  inline const Aws::String& GetWindowId() const { return m_windowId; }
  template <typename WindowIdT = Aws::String>
  void SetWindowId(WindowIdT&& value) {
    m_windowIdHasBeenSet = true;
    m_windowId = std::forward<WindowIdT>(value);
  }
  template <typename WindowIdT = Aws::String>
  UpdateMaintenanceWindowResult& WithWindowId(WindowIdT&& value) {
    SetWindowId(std::forward<WindowIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the maintenance window.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  UpdateMaintenanceWindowResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An optional description of the update.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  UpdateMaintenanceWindowResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time, in ISO-8601 Extended format, for when the maintenance
   * window is scheduled to become active. The maintenance window won't run before
   * this specified time.</p>
   */
  inline const Aws::String& GetStartDate() const { return m_startDate; }
  template <typename StartDateT = Aws::String>
  void SetStartDate(StartDateT&& value) {
    m_startDateHasBeenSet = true;
    m_startDate = std::forward<StartDateT>(value);
  }
  template <typename StartDateT = Aws::String>
  UpdateMaintenanceWindowResult& WithStartDate(StartDateT&& value) {
    SetStartDate(std::forward<StartDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time, in ISO-8601 Extended format, for when the maintenance
   * window is scheduled to become inactive. The maintenance window won't run after
   * this specified time.</p>
   */
  inline const Aws::String& GetEndDate() const { return m_endDate; }
  template <typename EndDateT = Aws::String>
  void SetEndDate(EndDateT&& value) {
    m_endDateHasBeenSet = true;
    m_endDate = std::forward<EndDateT>(value);
  }
  template <typename EndDateT = Aws::String>
  UpdateMaintenanceWindowResult& WithEndDate(EndDateT&& value) {
    SetEndDate(std::forward<EndDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The schedule of the maintenance window in the form of a cron or rate
   * expression.</p>
   */
  inline const Aws::String& GetSchedule() const { return m_schedule; }
  template <typename ScheduleT = Aws::String>
  void SetSchedule(ScheduleT&& value) {
    m_scheduleHasBeenSet = true;
    m_schedule = std::forward<ScheduleT>(value);
  }
  template <typename ScheduleT = Aws::String>
  UpdateMaintenanceWindowResult& WithSchedule(ScheduleT&& value) {
    SetSchedule(std::forward<ScheduleT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time zone that the scheduled maintenance window executions are based on,
   * in Internet Assigned Numbers Authority (IANA) format. For example:
   * "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a
   * href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA
   * website.</p>
   */
  inline const Aws::String& GetScheduleTimezone() const { return m_scheduleTimezone; }
  template <typename ScheduleTimezoneT = Aws::String>
  void SetScheduleTimezone(ScheduleTimezoneT&& value) {
    m_scheduleTimezoneHasBeenSet = true;
    m_scheduleTimezone = std::forward<ScheduleTimezoneT>(value);
  }
  template <typename ScheduleTimezoneT = Aws::String>
  UpdateMaintenanceWindowResult& WithScheduleTimezone(ScheduleTimezoneT&& value) {
    SetScheduleTimezone(std::forward<ScheduleTimezoneT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The number of days to wait to run a maintenance window after the scheduled
   * cron expression date and time.</p>
   */
  inline int GetScheduleOffset() const { return m_scheduleOffset; }
  inline void SetScheduleOffset(int value) {
    m_scheduleOffsetHasBeenSet = true;
    m_scheduleOffset = value;
  }
  inline UpdateMaintenanceWindowResult& WithScheduleOffset(int value) {
    SetScheduleOffset(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The duration of the maintenance window in hours.</p>
   */
  inline int GetDuration() const { return m_duration; }
  inline void SetDuration(int value) {
    m_durationHasBeenSet = true;
    m_duration = value;
  }
  inline UpdateMaintenanceWindowResult& WithDuration(int value) {
    SetDuration(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The number of hours before the end of the maintenance window that Amazon Web
   * Services Systems Manager stops scheduling new tasks for execution.</p>
   */
  inline int GetCutoff() const { return m_cutoff; }
  inline void SetCutoff(int value) {
    m_cutoffHasBeenSet = true;
    m_cutoff = value;
  }
  inline UpdateMaintenanceWindowResult& WithCutoff(int value) {
    SetCutoff(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Whether targets must be registered with the maintenance window before tasks
   * can be defined for those targets.</p>
   */
  inline bool GetAllowUnassociatedTargets() const { return m_allowUnassociatedTargets; }
  inline void SetAllowUnassociatedTargets(bool value) {
    m_allowUnassociatedTargetsHasBeenSet = true;
    m_allowUnassociatedTargets = value;
  }
  inline UpdateMaintenanceWindowResult& WithAllowUnassociatedTargets(bool value) {
    SetAllowUnassociatedTargets(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Whether the maintenance window is enabled.</p>
   */
  inline bool GetEnabled() const { return m_enabled; }
  inline void SetEnabled(bool value) {
    m_enabledHasBeenSet = true;
    m_enabled = value;
  }
  inline UpdateMaintenanceWindowResult& WithEnabled(bool value) {
    SetEnabled(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateMaintenanceWindowResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_windowId;

  Aws::String m_name;

  Aws::String m_description;

  Aws::String m_startDate;

  Aws::String m_endDate;

  Aws::String m_schedule;

  Aws::String m_scheduleTimezone;

  int m_scheduleOffset{0};

  int m_duration{0};

  int m_cutoff{0};

  bool m_allowUnassociatedTargets{false};

  bool m_enabled{false};

  Aws::String m_requestId;
  bool m_windowIdHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_startDateHasBeenSet = false;
  bool m_endDateHasBeenSet = false;
  bool m_scheduleHasBeenSet = false;
  bool m_scheduleTimezoneHasBeenSet = false;
  bool m_scheduleOffsetHasBeenSet = false;
  bool m_durationHasBeenSet = false;
  bool m_cutoffHasBeenSet = false;
  bool m_allowUnassociatedTargetsHasBeenSet = false;
  bool m_enabledHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SSM
}  // namespace Aws
