﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/sagemaker/model/ExperimentSource.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SageMaker {
namespace Model {

/**
 * <p>A summary of the properties of an experiment. To get the complete set of
 * properties, call the <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeExperiment.html">DescribeExperiment</a>
 * API and provide the <code>ExperimentName</code>.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ExperimentSummary">AWS
 * API Reference</a></p>
 */
class ExperimentSummary {
 public:
  AWS_SAGEMAKER_API ExperimentSummary() = default;
  AWS_SAGEMAKER_API ExperimentSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKER_API ExperimentSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the experiment.</p>
   */
  inline const Aws::String& GetExperimentArn() const { return m_experimentArn; }
  inline bool ExperimentArnHasBeenSet() const { return m_experimentArnHasBeenSet; }
  template <typename ExperimentArnT = Aws::String>
  void SetExperimentArn(ExperimentArnT&& value) {
    m_experimentArnHasBeenSet = true;
    m_experimentArn = std::forward<ExperimentArnT>(value);
  }
  template <typename ExperimentArnT = Aws::String>
  ExperimentSummary& WithExperimentArn(ExperimentArnT&& value) {
    SetExperimentArn(std::forward<ExperimentArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the experiment.</p>
   */
  inline const Aws::String& GetExperimentName() const { return m_experimentName; }
  inline bool ExperimentNameHasBeenSet() const { return m_experimentNameHasBeenSet; }
  template <typename ExperimentNameT = Aws::String>
  void SetExperimentName(ExperimentNameT&& value) {
    m_experimentNameHasBeenSet = true;
    m_experimentName = std::forward<ExperimentNameT>(value);
  }
  template <typename ExperimentNameT = Aws::String>
  ExperimentSummary& WithExperimentName(ExperimentNameT&& value) {
    SetExperimentName(std::forward<ExperimentNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the experiment as displayed. If <code>DisplayName</code> isn't
   * specified, <code>ExperimentName</code> is displayed.</p>
   */
  inline const Aws::String& GetDisplayName() const { return m_displayName; }
  inline bool DisplayNameHasBeenSet() const { return m_displayNameHasBeenSet; }
  template <typename DisplayNameT = Aws::String>
  void SetDisplayName(DisplayNameT&& value) {
    m_displayNameHasBeenSet = true;
    m_displayName = std::forward<DisplayNameT>(value);
  }
  template <typename DisplayNameT = Aws::String>
  ExperimentSummary& WithDisplayName(DisplayNameT&& value) {
    SetDisplayName(std::forward<DisplayNameT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ExperimentSource& GetExperimentSource() const { return m_experimentSource; }
  inline bool ExperimentSourceHasBeenSet() const { return m_experimentSourceHasBeenSet; }
  template <typename ExperimentSourceT = ExperimentSource>
  void SetExperimentSource(ExperimentSourceT&& value) {
    m_experimentSourceHasBeenSet = true;
    m_experimentSource = std::forward<ExperimentSourceT>(value);
  }
  template <typename ExperimentSourceT = ExperimentSource>
  ExperimentSummary& WithExperimentSource(ExperimentSourceT&& value) {
    SetExperimentSource(std::forward<ExperimentSourceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When the experiment was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  inline bool CreationTimeHasBeenSet() const { return m_creationTimeHasBeenSet; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  ExperimentSummary& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When the experiment was last modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedTime() const { return m_lastModifiedTime; }
  inline bool LastModifiedTimeHasBeenSet() const { return m_lastModifiedTimeHasBeenSet; }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  void SetLastModifiedTime(LastModifiedTimeT&& value) {
    m_lastModifiedTimeHasBeenSet = true;
    m_lastModifiedTime = std::forward<LastModifiedTimeT>(value);
  }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  ExperimentSummary& WithLastModifiedTime(LastModifiedTimeT&& value) {
    SetLastModifiedTime(std::forward<LastModifiedTimeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_experimentArn;
  bool m_experimentArnHasBeenSet = false;

  Aws::String m_experimentName;
  bool m_experimentNameHasBeenSet = false;

  Aws::String m_displayName;
  bool m_displayNameHasBeenSet = false;

  ExperimentSource m_experimentSource;
  bool m_experimentSourceHasBeenSet = false;

  Aws::Utils::DateTime m_creationTime{};
  bool m_creationTimeHasBeenSet = false;

  Aws::Utils::DateTime m_lastModifiedTime{};
  bool m_lastModifiedTimeHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
