﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/route53resolver/Route53Resolver_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Route53Resolver {
namespace Model {
class GetFirewallRuleGroupPolicyResult {
 public:
  AWS_ROUTE53RESOLVER_API GetFirewallRuleGroupPolicyResult() = default;
  AWS_ROUTE53RESOLVER_API GetFirewallRuleGroupPolicyResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ROUTE53RESOLVER_API GetFirewallRuleGroupPolicyResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Identity and Access Management (Amazon Web Services IAM) policy for
   * sharing the specified rule group. You can use the policy to share the rule group
   * using Resource Access Manager (RAM). </p>
   */
  inline const Aws::String& GetFirewallRuleGroupPolicy() const { return m_firewallRuleGroupPolicy; }
  template <typename FirewallRuleGroupPolicyT = Aws::String>
  void SetFirewallRuleGroupPolicy(FirewallRuleGroupPolicyT&& value) {
    m_firewallRuleGroupPolicyHasBeenSet = true;
    m_firewallRuleGroupPolicy = std::forward<FirewallRuleGroupPolicyT>(value);
  }
  template <typename FirewallRuleGroupPolicyT = Aws::String>
  GetFirewallRuleGroupPolicyResult& WithFirewallRuleGroupPolicy(FirewallRuleGroupPolicyT&& value) {
    SetFirewallRuleGroupPolicy(std::forward<FirewallRuleGroupPolicyT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetFirewallRuleGroupPolicyResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_firewallRuleGroupPolicy;
  bool m_firewallRuleGroupPolicyHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Route53Resolver
}  // namespace Aws
