﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>
#include <aws/lexv2-models/model/SlotTypeSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace LexModelsV2 {
namespace Model {
class ListSlotTypesResult {
 public:
  AWS_LEXMODELSV2_API ListSlotTypesResult() = default;
  AWS_LEXMODELSV2_API ListSlotTypesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_LEXMODELSV2_API ListSlotTypesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The identifier of the bot that contains the slot types.</p>
   */
  inline const Aws::String& GetBotId() const { return m_botId; }
  template <typename BotIdT = Aws::String>
  void SetBotId(BotIdT&& value) {
    m_botIdHasBeenSet = true;
    m_botId = std::forward<BotIdT>(value);
  }
  template <typename BotIdT = Aws::String>
  ListSlotTypesResult& WithBotId(BotIdT&& value) {
    SetBotId(std::forward<BotIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version of the bot that contains the slot types.</p>
   */
  inline const Aws::String& GetBotVersion() const { return m_botVersion; }
  template <typename BotVersionT = Aws::String>
  void SetBotVersion(BotVersionT&& value) {
    m_botVersionHasBeenSet = true;
    m_botVersion = std::forward<BotVersionT>(value);
  }
  template <typename BotVersionT = Aws::String>
  ListSlotTypesResult& WithBotVersion(BotVersionT&& value) {
    SetBotVersion(std::forward<BotVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The language and local of the slot types in the list.</p>
   */
  inline const Aws::String& GetLocaleId() const { return m_localeId; }
  template <typename LocaleIdT = Aws::String>
  void SetLocaleId(LocaleIdT&& value) {
    m_localeIdHasBeenSet = true;
    m_localeId = std::forward<LocaleIdT>(value);
  }
  template <typename LocaleIdT = Aws::String>
  ListSlotTypesResult& WithLocaleId(LocaleIdT&& value) {
    SetLocaleId(std::forward<LocaleIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Summary information for the slot types that meet the filter criteria
   * specified in the request. The length of the list is specified in the
   * <code>maxResults</code> parameter of the request. If there are more slot types
   * available, the <code>nextToken</code> field contains a token to get the next
   * page of results.</p>
   */
  inline const Aws::Vector<SlotTypeSummary>& GetSlotTypeSummaries() const { return m_slotTypeSummaries; }
  template <typename SlotTypeSummariesT = Aws::Vector<SlotTypeSummary>>
  void SetSlotTypeSummaries(SlotTypeSummariesT&& value) {
    m_slotTypeSummariesHasBeenSet = true;
    m_slotTypeSummaries = std::forward<SlotTypeSummariesT>(value);
  }
  template <typename SlotTypeSummariesT = Aws::Vector<SlotTypeSummary>>
  ListSlotTypesResult& WithSlotTypeSummaries(SlotTypeSummariesT&& value) {
    SetSlotTypeSummaries(std::forward<SlotTypeSummariesT>(value));
    return *this;
  }
  template <typename SlotTypeSummariesT = SlotTypeSummary>
  ListSlotTypesResult& AddSlotTypeSummaries(SlotTypeSummariesT&& value) {
    m_slotTypeSummariesHasBeenSet = true;
    m_slotTypeSummaries.emplace_back(std::forward<SlotTypeSummariesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A token that indicates whether there are more results to return in a response
   * to the <code>ListSlotTypes</code> operation. If the <code>nextToken</code> field
   * is present, you send the contents as the <code>nextToken</code> parameter of a
   * <code>ListSlotTypes</code> operation request to get the next page of
   * results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListSlotTypesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListSlotTypesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_botId;
  bool m_botIdHasBeenSet = false;

  Aws::String m_botVersion;
  bool m_botVersionHasBeenSet = false;

  Aws::String m_localeId;
  bool m_localeIdHasBeenSet = false;

  Aws::Vector<SlotTypeSummary> m_slotTypeSummaries;
  bool m_slotTypeSummariesHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
