﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/groundstation/GroundStation_EXPORTS.h>
#include <aws/groundstation/model/ConfigCapabilityType.h>
#include <aws/groundstation/model/ConfigTypeData.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace GroundStation {
namespace Model {
/**
 * <p/><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetConfigResponse">AWS
 * API Reference</a></p>
 */
class GetConfigResult {
 public:
  AWS_GROUNDSTATION_API GetConfigResult() = default;
  AWS_GROUNDSTATION_API GetConfigResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_GROUNDSTATION_API GetConfigResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>UUID of a <code>Config</code>.</p>
   */
  inline const Aws::String& GetConfigId() const { return m_configId; }
  template <typename ConfigIdT = Aws::String>
  void SetConfigId(ConfigIdT&& value) {
    m_configIdHasBeenSet = true;
    m_configId = std::forward<ConfigIdT>(value);
  }
  template <typename ConfigIdT = Aws::String>
  GetConfigResult& WithConfigId(ConfigIdT&& value) {
    SetConfigId(std::forward<ConfigIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>ARN of a <code>Config</code> </p>
   */
  inline const Aws::String& GetConfigArn() const { return m_configArn; }
  template <typename ConfigArnT = Aws::String>
  void SetConfigArn(ConfigArnT&& value) {
    m_configArnHasBeenSet = true;
    m_configArn = std::forward<ConfigArnT>(value);
  }
  template <typename ConfigArnT = Aws::String>
  GetConfigResult& WithConfigArn(ConfigArnT&& value) {
    SetConfigArn(std::forward<ConfigArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Name of a <code>Config</code>.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  GetConfigResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Type of a <code>Config</code>.</p>
   */
  inline ConfigCapabilityType GetConfigType() const { return m_configType; }
  inline void SetConfigType(ConfigCapabilityType value) {
    m_configTypeHasBeenSet = true;
    m_configType = value;
  }
  inline GetConfigResult& WithConfigType(ConfigCapabilityType value) {
    SetConfigType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Data elements in a <code>Config</code>.</p>
   */
  inline const ConfigTypeData& GetConfigData() const { return m_configData; }
  template <typename ConfigDataT = ConfigTypeData>
  void SetConfigData(ConfigDataT&& value) {
    m_configDataHasBeenSet = true;
    m_configData = std::forward<ConfigDataT>(value);
  }
  template <typename ConfigDataT = ConfigTypeData>
  GetConfigResult& WithConfigData(ConfigDataT&& value) {
    SetConfigData(std::forward<ConfigDataT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Tags assigned to a <code>Config</code>.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  GetConfigResult& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  GetConfigResult& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetConfigResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_configId;
  bool m_configIdHasBeenSet = false;

  Aws::String m_configArn;
  bool m_configArnHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  ConfigCapabilityType m_configType{ConfigCapabilityType::NOT_SET};
  bool m_configTypeHasBeenSet = false;

  ConfigTypeData m_configData;
  bool m_configDataHasBeenSet = false;

  Aws::Map<Aws::String, Aws::String> m_tags;
  bool m_tagsHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace GroundStation
}  // namespace Aws
