﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/clouddirectory/CloudDirectory_EXPORTS.h>
#include <aws/clouddirectory/model/ObjectReference.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CloudDirectory {
namespace Model {

/**
 * <p>Lists indices attached to an object inside a <a>BatchRead</a> operation. For
 * more information, see <a>ListAttachedIndices</a> and
 * <a>BatchReadRequest$Operations</a>.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchListAttachedIndices">AWS
 * API Reference</a></p>
 */
class BatchListAttachedIndices {
 public:
  AWS_CLOUDDIRECTORY_API BatchListAttachedIndices() = default;
  AWS_CLOUDDIRECTORY_API BatchListAttachedIndices(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUDDIRECTORY_API BatchListAttachedIndices& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUDDIRECTORY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A reference to the object that has indices attached.</p>
   */
  inline const ObjectReference& GetTargetReference() const { return m_targetReference; }
  inline bool TargetReferenceHasBeenSet() const { return m_targetReferenceHasBeenSet; }
  template <typename TargetReferenceT = ObjectReference>
  void SetTargetReference(TargetReferenceT&& value) {
    m_targetReferenceHasBeenSet = true;
    m_targetReference = std::forward<TargetReferenceT>(value);
  }
  template <typename TargetReferenceT = ObjectReference>
  BatchListAttachedIndices& WithTargetReference(TargetReferenceT&& value) {
    SetTargetReference(std::forward<TargetReferenceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The pagination token.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  BatchListAttachedIndices& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum number of results to retrieve.</p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline BatchListAttachedIndices& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}
 private:
  ObjectReference m_targetReference;
  bool m_targetReferenceHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  int m_maxResults{0};
  bool m_maxResultsHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudDirectory
}  // namespace Aws
