/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.fixtures.LightJavaCodeInsightFixtureTestCase;
import com.intellij.util.ThrowableRunnable;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public abstract class LightMultiFileTestCase
extends LightJavaCodeInsightFixtureTestCase {
    protected void doTest(ThrowableRunnable<? extends Exception> performAction) {
        this.doTest(performAction, this.getTestName(true));
    }

    protected void doTest(ThrowableRunnable<? extends Exception> performAction, boolean lowercaseFirstLetter) {
        this.doTest(performAction, this.getTestName(lowercaseFirstLetter));
    }

    protected void doTest(ThrowableRunnable<? extends Exception> performAction, String testName) {
        try {
            final VirtualFile actualDirectory = this.myFixture.copyDirectoryToProject(testName + "/before", "");
            performAction.run();
            final String expectedPath = this.getTestDataPath().replace(File.separatorChar, '/') + testName + "/after";
            VirtualFile rootAfter = LocalFileSystem.getInstance().findFileByPath(expectedPath);
            LightMultiFileTestCase.assertNotNull((Object)rootAfter);
            VfsUtilCore.visitChildrenRecursively((VirtualFile)actualDirectory, (VirtualFileVisitor)new VirtualFileVisitor<Void>(this, new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    file.putUserData(VfsTestUtil.TEST_DATA_FILE_PATH, (Object)Path.of(expectedPath, VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)actualDirectory)).toString());
                    return super.visitFile(file);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/LightMultiFileTestCase$1", "visitFile"));
                }
            });
            PlatformTestUtil.assertDirectoriesEqual(rootAfter, actualDirectory);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

