/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.impl;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.Nullable;

public final class UrlReferenceUtil {
    @Nullable
    public static PsiElement resolve(URLReference urlReference) {
        PsiFile file;
        urlReference.setIncorrectResourceMapped(false);
        String canonicalText = urlReference.getCanonicalText();
        if (canonicalText.isEmpty()) {
            XmlAttribute attr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)urlReference.getElement(), XmlAttribute.class);
            if (attr != null && attr.isNamespaceDeclaration() && attr.getNamespacePrefix().isEmpty() || ExternalResourceManagerEx.getInstanceEx().isIgnoredResource(canonicalText)) {
                return urlReference.getElement();
            }
            return null;
        }
        if (ExternalResourceManagerEx.getInstanceEx().isIgnoredResource(canonicalText)) {
            return urlReference.getElement();
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)urlReference.getElement(), XmlTag.class);
        if (tag != null && canonicalText.equals(tag.getAttributeValue("targetNamespace"))) {
            return tag;
        }
        PsiFile containingFile = urlReference.getElement().getContainingFile();
        if (tag != null && tag.getAttributeValue("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance") == null && (file = ExternalResourceManager.getInstance().getResourceLocation(canonicalText, containingFile, tag.getAttributeValue("version"))) != null) {
            return file;
        }
        if (containingFile instanceof XmlFile) {
            XmlDocument document = ((XmlFile)containingFile).getDocument();
            assert (document != null);
            XmlTag rootTag = document.getRootTag();
            if (rootTag == null) {
                return ExternalResourceManager.getInstance().getResourceLocation(canonicalText, containingFile, null);
            }
            XmlNSDescriptor nsDescriptor = rootTag.getNSDescriptor(canonicalText, true);
            if (nsDescriptor != null) {
                return nsDescriptor.getDescriptorFile();
            }
            String url = ExternalResourceManager.getInstance().getResourceLocation(canonicalText, urlReference.getElement().getProject());
            if (!url.equals(canonicalText)) {
                PsiFile file2 = XmlUtil.findRelativeFile((String)canonicalText, (PsiElement)urlReference.getElement().getContainingFile());
                if (file2 == null) {
                    urlReference.setIncorrectResourceMapped(true);
                }
                return file2;
            }
            if (tag == rootTag && (tag.getNamespace().equals("http://www.w3.org/2001/XMLSchema") || tag.getNamespace().equals("http://schemas.xmlsoap.org/wsdl/"))) {
                for (XmlTag t2 : tag.getSubTags()) {
                    String name = t2.getLocalName();
                    if ("import".equals(name)) {
                        if (!canonicalText.equals(t2.getAttributeValue("namespace"))) continue;
                        return t2;
                    }
                    if (!"include".equals(name) && !"redefine".equals(name) && !"annotation".equals(name)) break;
                }
            }
            PsiElement[] result = new PsiElement[1];
            URLReference.processWsdlSchemas((XmlTag)rootTag, t -> {
                if (canonicalText.equals(t.getAttributeValue("targetNamespace"))) {
                    result[0] = t;
                    return false;
                }
                for (XmlTag anImport : t.findSubTags("import", t.getNamespace())) {
                    XmlAttribute location;
                    if (!canonicalText.equals(anImport.getAttributeValue("namespace")) || (location = anImport.getAttribute("schemaLocation")) == null) continue;
                    result[0] = FileReferenceUtil.findFile((PsiElement)location.getValueElement());
                }
                return true;
            });
            return result[0];
        }
        return null;
    }
}

