/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.impl;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.serialization.JpsGlobalSettingsLoading;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.model.serialization.JpsPathMapper;
import org.jetbrains.jps.model.serialization.JpsProjectConfigurationLoading;
import org.jetbrains.jps.model.serialization.JpsProjectLoader;
import org.jetbrains.jps.model.serialization.JpsSerializationManager;
import org.jetbrains.jps.model.serialization.impl.JpsSerializationViaWorkspaceModel;

public final class JpsSerializationManagerImpl
extends JpsSerializationManager {
    @Override
    @NotNull
    public JpsModel loadModel(@NotNull String projectPath, @Nullable String optionsPathString, boolean loadUnloadedModules) throws IOException {
        if (projectPath == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(0);
        }
        Path optionsPath = optionsPathString == null ? null : Path.of(optionsPathString, new String[0]).normalize();
        Path externalConfigurationDirectory = JpsProjectConfigurationLoading.getExternalConfigurationDirectoryFromSystemProperty();
        JpsModel jpsModel = this.loadModel(Path.of(projectPath, new String[0]), externalConfigurationDirectory, optionsPath, loadUnloadedModules);
        if (jpsModel == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(1);
        }
        return jpsModel;
    }

    @Override
    @NotNull
    public JpsModel loadModel(@NotNull Path projectPath, @Nullable Path externalConfigurationDirectory, @Nullable Path optionsPath, boolean loadUnloadedModules) throws IOException {
        JpsSerializationViaWorkspaceModel serializationViaWorkspaceModel;
        if (projectPath == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(2);
        }
        if ((serializationViaWorkspaceModel = JpsSerializationViaWorkspaceModel.getInstance()) != null) {
            String projectCachePath = System.getProperty("jps.workspace.storage.project.cache.path");
            Path workspaceStorageCachePath = projectCachePath == null ? null : Path.of(projectCachePath, new String[0]);
            String globalCachePath = System.getProperty("jps.workspace.storage.global.cache.path");
            Path globalWorkspaceStoragePath = globalCachePath == null ? null : Path.of(globalCachePath, new String[0]);
            JpsModel jpsModel = serializationViaWorkspaceModel.loadModel(projectPath, workspaceStorageCachePath, externalConfigurationDirectory, optionsPath, globalWorkspaceStoragePath, loadUnloadedModules);
            if (jpsModel == null) {
                JpsSerializationManagerImpl.$$$reportNull$$$0(3);
            }
            return jpsModel;
        }
        JpsModel model = JpsElementFactory.getInstance().createModel();
        if (optionsPath != null) {
            JpsGlobalSettingsLoading.loadGlobalSettings(model.getGlobal(), optionsPath);
        }
        Map<String, String> pathVariables = JpsModelSerializationDataService.computeAllPathVariables(model.getGlobal());
        JpsProject project = model.getProject();
        JpsPathMapper pathMapper = model.getGlobal().getPathMapper();
        JpsProjectLoader.loadProject(project, pathVariables, pathMapper, projectPath, loadUnloadedModules, externalConfigurationDirectory);
        JpsModel jpsModel = model;
        if (jpsModel == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(4);
        }
        return jpsModel;
    }

    @Override
    @NotNull
    public JpsProject loadProject(@NotNull String projectPath, @NotNull Map<String, String> pathVariables) throws IOException {
        if (projectPath == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(5);
        }
        if (pathVariables == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(6);
        }
        JpsProject jpsProject = this.loadProject(projectPath, pathVariables, false);
        if (jpsProject == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(7);
        }
        return jpsProject;
    }

    @Override
    @NotNull
    public JpsProject loadProject(@NotNull String projectPathString, @NotNull Map<String, String> pathVariables, boolean loadUnloadedModules) throws IOException {
        if (projectPathString == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(8);
        }
        if (pathVariables == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(9);
        }
        Path projectPath = Paths.get(projectPathString, new String[0]);
        Path externalConfigurationDirectory = JpsProjectConfigurationLoading.getExternalConfigurationDirectoryFromSystemProperty();
        JpsProject jpsProject = this.loadProject(projectPath, externalConfigurationDirectory, pathVariables, loadUnloadedModules);
        if (jpsProject == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(10);
        }
        return jpsProject;
    }

    @Override
    @NotNull
    public JpsProject loadProject(@NotNull Path projectPath, @Nullable Path externalConfigurationDirectory, @NotNull Map<String, String> pathVariables, boolean loadUnloadedModules) throws IOException {
        JpsSerializationViaWorkspaceModel serializationViaWorkspaceModel;
        if (projectPath == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(11);
        }
        if (pathVariables == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(12);
        }
        if ((serializationViaWorkspaceModel = JpsSerializationViaWorkspaceModel.getInstance()) != null) {
            JpsProject jpsProject = serializationViaWorkspaceModel.loadProject(projectPath, externalConfigurationDirectory, pathVariables, loadUnloadedModules);
            if (jpsProject == null) {
                JpsSerializationManagerImpl.$$$reportNull$$$0(13);
            }
            return jpsProject;
        }
        JpsModel model = JpsElementFactory.getInstance().createModel();
        JpsProject project = model.getProject();
        JpsProjectLoader.loadProject(project, pathVariables, JpsPathMapper.IDENTITY, projectPath, loadUnloadedModules, externalConfigurationDirectory);
        JpsProject jpsProject = model.getProject();
        if (jpsProject == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(14);
        }
        return jpsProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/serialization/impl/JpsSerializationManagerImpl";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathVariables";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPathString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/serialization/impl/JpsSerializationManagerImpl";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModel";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "loadProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadModel";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 14: {
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

