/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.TermFrequencyAttribute;
import org.apache.lucene.codecs.TermVectorsWriter;
import org.apache.lucene.index.ByteSliceReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.ParallelPostingsArray;
import org.apache.lucene.index.TermVectorsConsumer;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBlockPool;

final class TermVectorsConsumerPerField
extends TermsHashPerField {
    private TermVectorsPostingsArray termVectorsPostingsArray;
    private final TermVectorsConsumer termsWriter;
    private final FieldInvertState fieldState;
    private final FieldInfo fieldInfo;
    private boolean doVectors;
    private boolean doVectorPositions;
    private boolean doVectorOffsets;
    private boolean doVectorPayloads;
    private OffsetAttribute offsetAttribute;
    private PayloadAttribute payloadAttribute;
    private TermFrequencyAttribute termFreqAtt;
    private final BytesRefBlockPool termBytePool;
    private boolean hasPayloads;

    TermVectorsConsumerPerField(FieldInvertState invertState, TermVectorsConsumer termsHash, FieldInfo fieldInfo) {
        super(2, termsHash.intPool, termsHash.bytePool, termsHash.termBytePool, termsHash.bytesUsed, null, fieldInfo.name, fieldInfo.getIndexOptions());
        this.termsWriter = termsHash;
        this.fieldInfo = fieldInfo;
        this.fieldState = invertState;
        this.termBytePool = new BytesRefBlockPool(termsHash.termBytePool);
    }

    @Override
    void finish() {
        if (!this.doVectors || this.getNumTerms() == 0) {
            return;
        }
        this.termsWriter.addFieldToFlush(this);
    }

    void finishDocument() throws IOException {
        if (!this.doVectors) {
            return;
        }
        this.doVectors = false;
        int numPostings = this.getNumTerms();
        BytesRef flushTerm = this.termsWriter.flushTerm;
        assert (numPostings >= 0);
        TermVectorsPostingsArray postings = this.termVectorsPostingsArray;
        TermVectorsWriter tv = this.termsWriter.writer;
        this.sortTerms();
        int[] termIDs = this.getSortedTermIDs();
        tv.startField(this.fieldInfo, numPostings, this.doVectorPositions, this.doVectorOffsets, this.hasPayloads);
        ByteSliceReader posReader = this.doVectorPositions ? this.termsWriter.vectorSliceReaderPos : null;
        ByteSliceReader offReader = this.doVectorOffsets ? this.termsWriter.vectorSliceReaderOff : null;
        for (int j = 0; j < numPostings; ++j) {
            int termID = termIDs[j];
            int freq = postings.freqs[termID];
            this.termBytePool.fillBytesRef(flushTerm, postings.textStarts[termID]);
            tv.startTerm(flushTerm, freq);
            if (this.doVectorPositions || this.doVectorOffsets) {
                if (posReader != null) {
                    this.initReader(posReader, termID, 0);
                }
                if (offReader != null) {
                    this.initReader(offReader, termID, 1);
                }
                tv.addProx(freq, posReader, offReader);
            }
            tv.finishTerm();
        }
        tv.finishField();
        this.reset();
        this.fieldInfo.setStoreTermVectors();
    }

    @Override
    boolean start(IndexableField field, boolean first) {
        super.start(field, first);
        this.termFreqAtt = this.fieldState.termFreqAttribute;
        assert (field.fieldType().indexOptions() != IndexOptions.NONE);
        if (first) {
            if (this.getNumTerms() != 0) {
                this.reset();
            }
            this.reinitHash();
            this.hasPayloads = false;
            this.doVectors = field.fieldType().storeTermVectors();
            if (this.doVectors) {
                this.doVectorPositions = field.fieldType().storeTermVectorPositions();
                this.doVectorOffsets = field.fieldType().storeTermVectorOffsets();
                if (this.doVectorPositions) {
                    this.doVectorPayloads = field.fieldType().storeTermVectorPayloads();
                } else {
                    this.doVectorPayloads = false;
                    if (field.fieldType().storeTermVectorPayloads()) {
                        throw new IllegalArgumentException("cannot index term vector payloads without term vector positions (field=\"" + field.name() + "\")");
                    }
                }
            } else {
                if (field.fieldType().storeTermVectorOffsets()) {
                    throw new IllegalArgumentException("cannot index term vector offsets when term vectors are not indexed (field=\"" + field.name() + "\")");
                }
                if (field.fieldType().storeTermVectorPositions()) {
                    throw new IllegalArgumentException("cannot index term vector positions when term vectors are not indexed (field=\"" + field.name() + "\")");
                }
                if (field.fieldType().storeTermVectorPayloads()) {
                    throw new IllegalArgumentException("cannot index term vector payloads when term vectors are not indexed (field=\"" + field.name() + "\")");
                }
            }
        } else {
            if (this.doVectors != field.fieldType().storeTermVectors()) {
                throw new IllegalArgumentException("all instances of a given field name must have the same term vectors settings (storeTermVectors changed for field=\"" + field.name() + "\")");
            }
            if (this.doVectorPositions != field.fieldType().storeTermVectorPositions()) {
                throw new IllegalArgumentException("all instances of a given field name must have the same term vectors settings (storeTermVectorPositions changed for field=\"" + field.name() + "\")");
            }
            if (this.doVectorOffsets != field.fieldType().storeTermVectorOffsets()) {
                throw new IllegalArgumentException("all instances of a given field name must have the same term vectors settings (storeTermVectorOffsets changed for field=\"" + field.name() + "\")");
            }
            if (this.doVectorPayloads != field.fieldType().storeTermVectorPayloads()) {
                throw new IllegalArgumentException("all instances of a given field name must have the same term vectors settings (storeTermVectorPayloads changed for field=\"" + field.name() + "\")");
            }
        }
        if (this.doVectors) {
            if (this.doVectorOffsets) {
                this.offsetAttribute = this.fieldState.offsetAttribute;
                assert (this.offsetAttribute != null);
            }
            this.payloadAttribute = this.doVectorPayloads ? this.fieldState.payloadAttribute : null;
        }
        return this.doVectors;
    }

    void writeProx(TermVectorsPostingsArray postings, int termID) {
        if (this.doVectorOffsets) {
            int startOffset = this.fieldState.offset + this.offsetAttribute.startOffset();
            int endOffset = this.fieldState.offset + this.offsetAttribute.endOffset();
            this.writeVInt(1, startOffset - postings.lastOffsets[termID]);
            this.writeVInt(1, endOffset - startOffset);
            postings.lastOffsets[termID] = endOffset;
        }
        if (this.doVectorPositions) {
            BytesRef payload = this.payloadAttribute == null ? null : this.payloadAttribute.getPayload();
            int pos = this.fieldState.position - postings.lastPositions[termID];
            if (payload != null && payload.length > 0) {
                this.writeVInt(0, pos << 1 | 1);
                this.writeVInt(0, payload.length);
                this.writeBytes(0, payload.bytes, payload.offset, payload.length);
                this.hasPayloads = true;
            } else {
                this.writeVInt(0, pos << 1);
            }
            postings.lastPositions[termID] = this.fieldState.position;
        }
    }

    @Override
    void newTerm(int termID, int docID) {
        TermVectorsPostingsArray postings = this.termVectorsPostingsArray;
        postings.freqs[termID] = this.getTermFreq();
        postings.lastOffsets[termID] = 0;
        postings.lastPositions[termID] = 0;
        this.writeProx(postings, termID);
    }

    @Override
    void addTerm(int termID, int docID) {
        TermVectorsPostingsArray postings = this.termVectorsPostingsArray;
        int n = termID;
        postings.freqs[n] = postings.freqs[n] + this.getTermFreq();
        this.writeProx(postings, termID);
    }

    private int getTermFreq() {
        if (this.termFreqAtt == null) {
            return 1;
        }
        int freq = this.termFreqAtt.getTermFrequency();
        if (freq != 1) {
            if (this.doVectorPositions) {
                throw new IllegalArgumentException("field \"" + this.getFieldName() + "\": cannot index term vector positions while using custom TermFrequencyAttribute");
            }
            if (this.doVectorOffsets) {
                throw new IllegalArgumentException("field \"" + this.getFieldName() + "\": cannot index term vector offsets while using custom TermFrequencyAttribute");
            }
        }
        return freq;
    }

    @Override
    public void newPostingsArray() {
        this.termVectorsPostingsArray = (TermVectorsPostingsArray)this.postingsArray;
    }

    @Override
    ParallelPostingsArray createPostingsArray(int size) {
        return new TermVectorsPostingsArray(size);
    }

    static final class TermVectorsPostingsArray
    extends ParallelPostingsArray {
        int[] freqs;
        int[] lastOffsets;
        int[] lastPositions;

        TermVectorsPostingsArray(int size) {
            super(size);
            this.freqs = new int[size];
            this.lastOffsets = new int[size];
            this.lastPositions = new int[size];
        }

        @Override
        ParallelPostingsArray newInstance(int size) {
            return new TermVectorsPostingsArray(size);
        }

        @Override
        void copyTo(ParallelPostingsArray toArray, int numToCopy) {
            assert (toArray instanceof TermVectorsPostingsArray);
            TermVectorsPostingsArray to = (TermVectorsPostingsArray)toArray;
            super.copyTo(toArray, numToCopy);
            System.arraycopy(this.freqs, 0, to.freqs, 0, this.size);
            System.arraycopy(this.lastOffsets, 0, to.lastOffsets, 0, this.size);
            System.arraycopy(this.lastPositions, 0, to.lastPositions, 0, this.size);
        }

        @Override
        int bytesPerPosting() {
            return super.bytesPerPosting() + 12;
        }
    }
}

