/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.ChangesViewWorkflowManager;
import com.intellij.openapi.vcs.changes.CommitChangesViewWithToolbarPanel;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.commit.ChangesViewCommitPanel;
import com.intellij.vcs.commit.ChangesViewCommitWorkflow;
import com.intellij.vcs.commit.ChangesViewCommitWorkflowHandler;
import com.intellij.vcs.commit.CommitMode;
import com.intellij.vcs.commit.CommitModeManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0003J\b\u0010\r\u001a\u00020\fH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewWorkflowManagerImpl;", "Lcom/intellij/openapi/vcs/changes/ChangesViewWorkflowManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "_commitWorkflowHandler", "Lcom/intellij/vcs/commit/ChangesViewCommitWorkflowHandler;", "isInitialized", "", "updateCommitWorkflowHandler", "", "dispose", "doGetCommitWorkflowHandler", "intellij.platform.vcs.impl"})
public final class ChangesViewWorkflowManagerImpl
extends ChangesViewWorkflowManager
implements Disposable {
    @NotNull
    private final Project project;
    @Nullable
    private ChangesViewCommitWorkflowHandler _commitWorkflowHandler;
    private boolean isInitialized;

    public ChangesViewWorkflowManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        MessageBusConnection busConnection = this.project.getMessageBus().connect((Disposable)this);
        CommitModeManager.Companion.subscribeOnCommitModeChange((SimpleMessageBusConnection)busConnection, new CommitModeManager.CommitModeListener(){

            @Override
            public void commitModeChanged() {
                this.updateCommitWorkflowHandler();
            }
        });
        ApplicationManager.getApplication().invokeLater(() -> ChangesViewWorkflowManagerImpl._init_$lambda$0(this), ModalityState.nonModal(), this.project.getDisposed());
    }

    @RequiresEdt
    private final void updateCommitWorkflowHandler() {
        this.isInitialized = true;
        boolean isNonModal = CommitModeManager.Companion.getInstance(this.project).getCurrentCommitMode() instanceof CommitMode.NonModalCommitMode;
        ChangesViewCommitWorkflowHandler currentHandler = this._commitWorkflowHandler;
        if (isNonModal) {
            if (currentHandler == null) {
                Activity activity = StartUpMeasurer.startActivity((String)"ChangesViewWorkflowManager initialization");
                Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"startActivity(...)");
                Activity activity2 = activity;
                ChangesViewI changesViewI = ChangesViewManager.getInstance(this.project);
                Intrinsics.checkNotNull((Object)changesViewI, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.changes.ChangesViewManager");
                CommitChangesViewWithToolbarPanel commitChangesViewWithToolbarPanel = ((ChangesViewManager)changesViewI).initChangesPanel();
                Intrinsics.checkNotNullExpressionValue((Object)commitChangesViewWithToolbarPanel, (String)"initChangesPanel(...)");
                CommitChangesViewWithToolbarPanel changesPanel = commitChangesViewWithToolbarPanel;
                ChangesViewCommitWorkflow workflow = new ChangesViewCommitWorkflow(this.project);
                ChangesViewCommitPanel commitPanel = new ChangesViewCommitPanel(this.project, changesPanel.getChangesView());
                this._commitWorkflowHandler = new ChangesViewCommitWorkflowHandler(workflow, commitPanel);
                MessageBus messageBus = this.project.getMessageBus();
                Topic<ChangesViewWorkflowManager.ChangesViewWorkflowListener> topic = ChangesViewWorkflowManager.TOPIC;
                Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
                ((ChangesViewWorkflowManager.ChangesViewWorkflowListener)messageBus.syncPublisher(topic)).commitWorkflowChanged();
                activity2.end();
            } else {
                currentHandler.resetActivation();
            }
        } else if (currentHandler != null) {
            Disposer.dispose((Disposable)currentHandler);
            this._commitWorkflowHandler = null;
            MessageBus messageBus = this.project.getMessageBus();
            Topic<ChangesViewWorkflowManager.ChangesViewWorkflowListener> topic = ChangesViewWorkflowManager.TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
            ((ChangesViewWorkflowManager.ChangesViewWorkflowListener)messageBus.syncPublisher(topic)).commitWorkflowChanged();
        }
    }

    public void dispose() {
        ChangesViewCommitWorkflowHandler handler = this._commitWorkflowHandler;
        if (handler != null) {
            Disposer.dispose((Disposable)handler);
            this._commitWorkflowHandler = null;
        }
    }

    @Override
    @Nullable
    protected ChangesViewCommitWorkflowHandler doGetCommitWorkflowHandler() {
        if (ApplicationManager.getApplication().isDispatchThread() && !this.isInitialized) {
            this.updateCommitWorkflowHandler();
        }
        return this._commitWorkflowHandler;
    }

    private static final void _init_$lambda$0(ChangesViewWorkflowManagerImpl this$0) {
        this$0.updateCommitWorkflowHandler();
    }
}

