/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.PlaybackCommandCoroutineAdapter;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.Scope;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.jetbrains.performancePlugin.commands.MemoryCapture;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0094@\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/performancePlugin/commands/CaptureMemoryMetricsCommand;", "Lcom/intellij/openapi/ui/playback/commands/PlaybackCommandCoroutineAdapter;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "otelMeter", "Lio/opentelemetry/api/metrics/Meter;", "getOtelMeter", "()Lio/opentelemetry/api/metrics/Meter;", "doExecute", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "(Lcom/intellij/openapi/ui/playback/PlaybackContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.performanceTesting"})
public final class CaptureMemoryMetricsCommand
extends PlaybackCommandCoroutineAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Meter otelMeter;
    @NotNull
    public static final String PREFIX = "%captureMemoryMetrics";
    @NotNull
    public static final String SPAN_NAME = "memoryUsage";
    @Nullable
    private static Long prevHeapUsageMb;

    public CaptureMemoryMetricsCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
        this.otelMeter = TelemetryManager.Companion.getMeter(new Scope("test", PlatformScopesKt.PlatformMetrics, false, 4, null));
    }

    @NotNull
    public final Meter getOtelMeter() {
        return this.otelMeter;
    }

    @Nullable
    protected Object doExecute(@NotNull PlaybackContext context, @NotNull Continuation<? super Unit> $completion) {
        String postfix = this.extractCommandArgument(PREFIX);
        LongCounter heapUsageMb = this.otelMeter.counterBuilder("JVM.heapUsageMb" + postfix).build();
        LongCounter diffHeapUsageMb = this.otelMeter.counterBuilder("JVM.diffHeapUsageMb" + postfix).build();
        MemoryCapture memory = MemoryCapture.Companion.capture();
        heapUsageMb.add(memory.getUsedMb());
        Long l2 = prevHeapUsageMb;
        if (l2 != null) {
            Long l3 = l2;
            long it = ((Number)l3).longValue();
            boolean bl = false;
            if (it > 0L) {
                diffHeapUsageMb.add(it - memory.getUsedMb());
            }
        }
        prevHeapUsageMb = Boxing.boxLong((long)memory.getUsedMb());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/performancePlugin/commands/CaptureMemoryMetricsCommand$Companion;", "", "<init>", "()V", "PREFIX", "", "SPAN_NAME", "prevHeapUsageMb", "", "Ljava/lang/Long;", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

