/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.git.branch.tree;

import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.ui.SeparatorWithText;
import com.intellij.vcs.git.branch.popup.GitBranchesPopupBase;
import com.intellij.vcs.git.branch.tree.GitBranchesTreeModel;
import com.intellij.vcs.git.branch.tree.GitBranchesTreeModelUtilKt;
import com.intellij.vcs.git.branch.tree.GitBranchesTreeSingleRepoModel;
import com.intellij.vcs.git.branch.tree.LazyRepositoryHolder;
import com.intellij.vcs.git.repo.GitRepositoryModel;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0007H\u0014J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0014R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/git/branch/tree/GitBranchesTreeSelectedRepoModel;", "Lcom/intellij/vcs/git/branch/tree/GitBranchesTreeSingleRepoModel;", "project", "Lcom/intellij/openapi/project/Project;", "selectedRepository", "Lcom/intellij/vcs/git/repo/GitRepositoryModel;", "allProjectRepositories", "", "topLevelActions", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/git/repo/GitRepositoryModel;Ljava/util/List;Ljava/util/List;)V", "actionsSeparator", "Lcom/intellij/ui/SeparatorWithText;", "branchesSubtreeSeparator", "repositoriesTree", "Lcom/intellij/vcs/git/branch/tree/LazyRepositoryHolder;", "rebuild", "", "matcher", "Lcom/intellij/psi/codeStyle/MinusculeMatcher;", "getTopLevelNodes", "getPreferredSelection", "Ljavax/swing/tree/TreePath;", "notHaveFilteredNodes", "", "intellij.vcs.git.shared"})
@SourceDebugExtension(value={"SMAP\nGitBranchesTreeSelectedRepoModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBranchesTreeSelectedRepoModel.kt\ncom/intellij/vcs/git/branch/tree/GitBranchesTreeSelectedRepoModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class GitBranchesTreeSelectedRepoModel
extends GitBranchesTreeSingleRepoModel {
    @NotNull
    private final List<GitRepositoryModel> allProjectRepositories;
    @NotNull
    private final SeparatorWithText actionsSeparator;
    @NotNull
    private final SeparatorWithText branchesSubtreeSeparator;
    private LazyRepositoryHolder repositoriesTree;

    public GitBranchesTreeSelectedRepoModel(@NotNull Project project, @NotNull GitRepositoryModel selectedRepository, @NotNull List<? extends GitRepositoryModel> allProjectRepositories, @NotNull List<? extends Object> topLevelActions) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)selectedRepository, (String)"selectedRepository");
        Intrinsics.checkNotNullParameter(allProjectRepositories, (String)"allProjectRepositories");
        Intrinsics.checkNotNullParameter(topLevelActions, (String)"topLevelActions");
        super(project, selectedRepository, topLevelActions);
        this.allProjectRepositories = allProjectRepositories;
        this.actionsSeparator = GitBranchesPopupBase.Companion.createTreeSeparator$intellij_vcs_git_shared$default(GitBranchesPopupBase.Companion, null, 1, null);
        this.branchesSubtreeSeparator = GitBranchesPopupBase.Companion.createTreeSeparator$intellij_vcs_git_shared$default(GitBranchesPopupBase.Companion, null, 1, null);
    }

    @Override
    protected void rebuild(@Nullable MinusculeMatcher matcher) {
        super.rebuild(matcher);
        this.repositoriesTree = new LazyRepositoryHolder(this.getProject(), this.allProjectRepositories, matcher, false);
    }

    @Override
    @NotNull
    protected List<Object> getTopLevelNodes() {
        Collection matchedRepos;
        Collection matchedActions = this.getActionsTree().getMatch();
        LazyRepositoryHolder lazyRepositoryHolder = this.repositoriesTree;
        if (lazyRepositoryHolder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repositoriesTree");
            lazyRepositoryHolder = null;
        }
        if (!(matchedRepos = lazyRepositoryHolder.getMatch()).isEmpty()) {
            GitBranchesTreeModelUtilKt.addSeparatorIfNeeded(matchedActions, this.actionsSeparator);
        }
        List topNodes = CollectionsKt.plus(matchedActions, (Iterable)matchedRepos);
        List<Object> localAndRemoteNodes = GitBranchesTreeModelUtilKt.getLocalAndRemoteTopLevelNodes(this.getLocalBranchesTree(), this.getRemoteBranchesTree(), this.getTagsTree(), this.getRecentCheckoutBranchesTree());
        return localAndRemoteNodes.isEmpty() ? topNodes : CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)topNodes, (Object)this.branchesSubtreeSeparator), (Iterable)localAndRemoteNodes);
    }

    @Override
    @Nullable
    public TreePath getPreferredSelection() {
        TreePath treePath;
        Object n;
        Object object = this.getActionsTree().getTopMatch();
        if (object == null) {
            LazyRepositoryHolder lazyRepositoryHolder = this.repositoriesTree;
            if (lazyRepositoryHolder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repositoriesTree");
                lazyRepositoryHolder = null;
            }
            if ((object = (GitBranchesTreeModel.RepositoryNode)lazyRepositoryHolder.getTopMatch()) == null) {
                object = this.getPreferredBranch();
            }
        }
        if ((n = object) != null) {
            Object it = n;
            boolean bl = false;
            treePath = GitBranchesTreeModelUtilKt.createTreePathFor(this, it);
        } else {
            treePath = null;
        }
        return treePath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean notHaveFilteredNodes() {
        if (!super.notHaveFilteredNodes()) return false;
        LazyRepositoryHolder lazyRepositoryHolder = this.repositoriesTree;
        if (lazyRepositoryHolder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repositoriesTree");
            lazyRepositoryHolder = null;
        }
        if (!lazyRepositoryHolder.isEmpty()) return false;
        return true;
    }
}

