/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CompareCellsAction
extends AnAction
implements DumbAware {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CompareCellsAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            CompareCellsAction.$$$reportNull$$$0(1);
        }
        SelectionModel model2 = (grid = GridUtil.getDataGrid(e.getDataContext())) == null ? null : grid.getSelectionModel();
        int cells = model2 == null ? 0 : model2.getSelectedColumns().size() * model2.getSelectedRows().size();
        e.getPresentation().setEnabledAndVisible(cells > 1 && cells <= 3);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            CompareCellsAction.$$$reportNull$$$0(2);
        }
        if ((grid = GridUtil.getDataGrid(e.getDataContext())) == null) {
            return;
        }
        SelectionModel model2 = grid.getSelectionModel();
        ModelIndexSet columns = model2.getSelectedColumns();
        ModelIndexSet rows = model2.getSelectedRows();
        List<Cell> cells = CompareCellsAction.getCells((ModelIndexSet<GridRow>)rows, (ModelIndexSet<GridColumn>)columns, grid);
        DiffContentFactory factory = DiffContentFactory.getInstance();
        List contents = ContainerUtil.map(cells, v -> factory.create(v.value, (FileType)v.language.getAssociatedFileType()));
        List titles = ContainerUtil.map(cells, v -> v.title);
        String tableName = GridHelper.get(grid).getTableName(grid);
        String title = StringUtil.join((Collection)titles, (String)" vs ") + (tableName == null ? null : " (" + tableName + ")");
        SimpleDiffRequest request = new SimpleDiffRequest(title, contents, titles);
        DiffManager.getInstance().showDiff(e.getProject(), (DiffRequest)request);
    }

    @NotNull
    private static List<Cell> getCells(@NotNull ModelIndexSet<GridRow> rowsIdxs, @NotNull ModelIndexSet<GridColumn> columnsIdxs, @NotNull DataGrid grid) {
        if (rowsIdxs == null) {
            CompareCellsAction.$$$reportNull$$$0(3);
        }
        if (columnsIdxs == null) {
            CompareCellsAction.$$$reportNull$$$0(4);
        }
        if (grid == null) {
            CompareCellsAction.$$$reportNull$$$0(5);
        }
        GridModel dataModel = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        ObjectFormatter formatter = grid.getObjectFormatter();
        ArrayList<Cell> result = new ArrayList<Cell>();
        for (ModelIndex columnIdx : columnsIdxs.asIterable()) {
            GridColumn column = Objects.requireNonNull((GridColumn)dataModel.getColumn(columnIdx));
            for (ModelIndex rowIdx : rowsIdxs.asIterable()) {
                GridRow row = Objects.requireNonNull((GridRow)dataModel.getRow(rowIdx));
                Object value = dataModel.getValueAt(rowIdx, columnIdx);
                String stringValue = formatter.objectToString(value, column, (ObjectFormatterConfig)GridUtil.createFormatterConfig(grid, (ModelIndex<GridColumn>)columnIdx));
                stringValue = Objects.requireNonNullElse(stringValue, "null");
                String title = column.getName() + ":" + row.getRowNum();
                Language language = grid.getContentLanguage((ModelIndex<GridColumn>)columnIdx);
                result.add(new Cell(stringValue, title, language));
            }
        }
        ArrayList<Cell> arrayList = result;
        if (arrayList == null) {
            CompareCellsAction.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/CompareCellsAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowsIdxs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsIdxs";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/CompareCellsAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCells";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCells";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    private static class Cell {
        private final String value;
        private final String title;
        private final Language language;

        Cell(@NotNull String value, @NotNull String title, @NotNull Language language) {
            if (value == null) {
                Cell.$$$reportNull$$$0(0);
            }
            if (title == null) {
                Cell.$$$reportNull$$$0(1);
            }
            if (language == null) {
                Cell.$$$reportNull$$$0(2);
            }
            this.value = value;
            this.title = title;
            this.language = language;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "language";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/CompareCellsAction$Cell";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

