/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.diff.data;

import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.util.Side;
import com.intellij.lang.Language;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.diff.data.FileInfo;
import com.intellij.lang.properties.diff.data.PropertyInfo;
import com.intellij.lang.properties.diff.data.SemiOpenLineRange;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/properties/diff/data/FileInfoHolder;", "", "left", "Lcom/intellij/lang/properties/diff/data/FileInfo;", "right", "<init>", "(Lcom/intellij/lang/properties/diff/data/FileInfo;Lcom/intellij/lang/properties/diff/data/FileInfo;)V", "get", "side", "Lcom/intellij/diff/util/Side;", "Companion", "intellij.properties.backend"})
public final class FileInfoHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileInfo left;
    @NotNull
    private final FileInfo right;

    private FileInfoHolder(FileInfo left, FileInfo right) {
        this.left = left;
        this.right = right;
    }

    @NotNull
    public final FileInfo get(@NotNull Side side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return switch (WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
            case 1 -> this.left;
            case 2 -> this.right;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @JvmStatic
    @Nullable
    public static final FileInfoHolder create$intellij_properties_backend(@NotNull Project project, @NotNull CharSequence leftText, @NotNull CharSequence rightText) {
        return Companion.create$intellij_properties_backend(project, leftText, rightText);
    }

    public /* synthetic */ FileInfoHolder(FileInfo left, FileInfo right, DefaultConstructorMarker $constructor_marker) {
        this(left, right);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0001\u00a2\u0006\u0002\b\u000bJ\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/lang/properties/diff/data/FileInfoHolder$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/lang/properties/diff/data/FileInfoHolder;", "project", "Lcom/intellij/openapi/project/Project;", "leftText", "", "rightText", "create$intellij_properties_backend", "createFileInfo", "Lcom/intellij/lang/properties/diff/data/FileInfo;", "text", "intellij.properties.backend"})
    @SourceDebugExtension(value={"SMAP\nFileInfoHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileInfoHolder.kt\ncom/intellij/lang/properties/diff/data/FileInfoHolder$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n1193#2,2:43\n1267#2,4:45\n*S KotlinDebug\n*F\n+ 1 FileInfoHolder.kt\ncom/intellij/lang/properties/diff/data/FileInfoHolder$Companion\n*L\n30#1:43,2\n30#1:45,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final FileInfoHolder create$intellij_properties_backend(@NotNull Project project, @NotNull CharSequence leftText, @NotNull CharSequence rightText) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)leftText, (String)"leftText");
            Intrinsics.checkNotNullParameter((Object)rightText, (String)"rightText");
            FileInfo fileInfo = this.createFileInfo(project, leftText);
            if (fileInfo == null) {
                return null;
            }
            FileInfo left = fileInfo;
            FileInfo fileInfo2 = this.createFileInfo(project, rightText);
            if (fileInfo2 == null) {
                return null;
            }
            FileInfo right = fileInfo2;
            return new FileInfoHolder(left, right, null);
        }

        /*
         * WARNING - void declaration
         */
        private final FileInfo createFileInfo(Project project, CharSequence text) {
            void $this$associateTo$iv$iv;
            PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText((Language)PropertiesLanguage.INSTANCE, text);
            if (!(file instanceof PropertiesFile)) {
                return null;
            }
            LineOffsets lineOffsets = LineOffsetsUtil.create((Document)file.getFileDocument());
            Intrinsics.checkNotNullExpressionValue((Object)lineOffsets, (String)"create(...)");
            LineOffsets lineOffsets2 = lineOffsets;
            List list = ((PropertiesFile)file).getProperties();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getProperties(...)");
            List propertiesList = list;
            Iterable $this$associate$iv = propertiesList;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                String value;
                String key;
                Map map = destination$iv$iv;
                IProperty property = (IProperty)element$iv$iv;
                boolean bl = false;
                if (!(property instanceof Property)) {
                    return null;
                }
                if (((Property)property).getUnescapedKey() == null) {
                    return null;
                }
                if (((Property)property).getUnescapedValue() == null) {
                    return null;
                }
                int startLine = lineOffsets2.getLineNumber(((Property)property).getTextRange().getStartOffset());
                int endLine = lineOffsets2.getLineNumber(((Property)property).getTextRange().getEndOffset());
                Pair pair = TuplesKt.to((Object)key, (Object)new PropertyInfo(key, value, new SemiOpenLineRange(startLine, endLine + 1)));
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map map = destination$iv$iv;
            if (map.size() != propertiesList.size()) {
                return null;
            }
            return new FileInfo(text, lineOffsets2, map);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Side.values().length];
            try {
                nArray[Side.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Side.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

