/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.kotlin.sdk.types;

import io.modelcontextprotocol.kotlin.sdk.types.AudioContent;
import io.modelcontextprotocol.kotlin.sdk.types.ContentTypes;
import io.modelcontextprotocol.kotlin.sdk.types.ImageContent;
import io.modelcontextprotocol.kotlin.sdk.types.MediaContent;
import io.modelcontextprotocol.kotlin.sdk.types.SerializersKt;
import io.modelcontextprotocol.kotlin.sdk.types.TextContent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.json.JsonContentPolymorphicSerializer;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lio/modelcontextprotocol/kotlin/sdk/types/MediaContentPolymorphicSerializer;", "Lkotlinx/serialization/json/JsonContentPolymorphicSerializer;", "Lio/modelcontextprotocol/kotlin/sdk/types/MediaContent;", "<init>", "()V", "Lkotlinx/serialization/json/JsonElement;", "element", "Lkotlinx/serialization/DeserializationStrategy;", "selectDeserializer", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/DeserializationStrategy;", "kotlin-sdk-core"})
public final class MediaContentPolymorphicSerializer
extends JsonContentPolymorphicSerializer<MediaContent> {
    @NotNull
    public static final MediaContentPolymorphicSerializer INSTANCE = new MediaContentPolymorphicSerializer();

    private MediaContentPolymorphicSerializer() {
        super(Reflection.getOrCreateKotlinClass(MediaContent.class));
    }

    @NotNull
    protected DeserializationStrategy<MediaContent> selectDeserializer(@NotNull JsonElement element) {
        DeserializationStrategy deserializationStrategy;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = SerializersKt.access$getType(element);
        if (Intrinsics.areEqual((Object)string, (Object)ContentTypes.TEXT.getValue())) {
            deserializationStrategy = (DeserializationStrategy)TextContent.Companion.serializer();
        } else if (Intrinsics.areEqual((Object)string, (Object)ContentTypes.IMAGE.getValue())) {
            deserializationStrategy = (DeserializationStrategy)ImageContent.Companion.serializer();
        } else if (Intrinsics.areEqual((Object)string, (Object)ContentTypes.AUDIO.getValue())) {
            deserializationStrategy = (DeserializationStrategy)AudioContent.Companion.serializer();
        } else {
            throw new SerializationException("Unknown media content type: " + SerializersKt.access$getTypeOrNull(element));
        }
        return deserializationStrategy;
    }
}

