/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.declaration;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.template.expressions.ChooseTypeExpression;

public final class GrSetStrongTypeIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance(GrSetStrongTypeIntention.class);

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, final Editor editor) throws IncorrectOperationException {
        PsiElement elementToBuildTemplate;
        GrVariable[] variables;
        PsiElement parent;
        if (element == null) {
            GrSetStrongTypeIntention.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GrSetStrongTypeIntention.$$$reportNull$$$0(1);
        }
        if ((parent = element.getParent()) instanceof GrVariable && parent.getParent() instanceof GrVariableDeclaration) {
            variables = ((GrVariableDeclaration)parent.getParent()).getVariables();
            elementToBuildTemplate = parent.getParent();
        } else if (parent instanceof GrVariable && parent.getParent() instanceof GrForInClause) {
            variables = new GrVariable[]{(GrVariable)parent};
            elementToBuildTemplate = parent.getParent().getParent();
        } else if (parent instanceof GrVariableDeclaration) {
            variables = ((GrVariableDeclaration)parent).getVariables();
            elementToBuildTemplate = parent;
        } else if (parent instanceof GrParameter && parent.getParent() instanceof GrParameterList) {
            variables = new GrVariable[]{(GrVariable)parent};
            elementToBuildTemplate = parent.getParent().getParent();
        } else if (parent instanceof GrVariable) {
            variables = new GrVariable[]{(GrVariable)parent};
            elementToBuildTemplate = parent;
        } else {
            return;
        }
        ArrayList<SupertypeConstraint> types = new ArrayList<SupertypeConstraint>();
        PsiElement psiElement = parent.getParent();
        if (psiElement instanceof GrForInClause) {
            GrForInClause clause = (GrForInClause)psiElement;
            GrVariable indexVariable = clause.getIndexVariable();
            if (indexVariable == parent) {
                types.add(SupertypeConstraint.create(Objects.requireNonNull(indexVariable.getTypeGroovy())));
            } else {
                types.add(SupertypeConstraint.create(PsiUtil.extractIteratedType((GrForInClause)parent.getParent())));
            }
        } else {
            for (GrVariable variable : variables) {
                GrParameter parameter;
                PsiType type;
                PsiType type2;
                GrExpression initializer = variable.getInitializerGroovy();
                if (initializer != null && (type2 = initializer.getType()) != null) {
                    types.add(SupertypeConstraint.create(type2));
                }
                if (!(variable instanceof GrParameter) || (type = GrSetStrongTypeIntention.getClosureParameterType(parameter = (GrParameter)variable)) == null) continue;
                types.add(SupertypeConstraint.create(type));
            }
        }
        final String originalText = elementToBuildTemplate.getText();
        final TypeInfo typeInfo = GrSetStrongTypeIntention.getOrCreateTypeElement(parent, elementToBuildTemplate);
        PsiElement replaceElement = typeInfo.elementToReplace;
        TypeConstraint[] constraints = types.toArray(TypeConstraint.EMPTY_ARRAY);
        ChooseTypeExpression chooseTypeExpression = new ChooseTypeExpression(constraints, element.getManager(), replaceElement.getResolveScope());
        TemplateBuilderImpl builder = new TemplateBuilderImpl(elementToBuildTemplate);
        builder.replaceElement(replaceElement, (Expression)chooseTypeExpression);
        final Document document = editor.getDocument();
        final RangeMarker rangeMarker = document.createRangeMarker(elementToBuildTemplate.getTextRange());
        rangeMarker.setGreedyToRight(true);
        rangeMarker.setGreedyToLeft(true);
        PsiElement afterPostprocess = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)elementToBuildTemplate);
        Template template = builder.buildTemplate();
        TextRange range = afterPostprocess.getTextRange();
        document.deleteString(range.getStartOffset(), range.getEndOffset());
        if (rangeMarker.isValid()) {
            editor.getCaretModel().moveToOffset(rangeMarker.getStartOffset());
        }
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        templateManager.startTemplate(editor, template, (TemplateEditingListener)new TemplateEditingAdapter(this){

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                if (template == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (brokenOff) {
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        if (rangeMarker.isValid()) {
                            document.replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)originalText);
                            editor.getCaretModel().moveToOffset(rangeMarker.getStartOffset() + typeInfo2.originalOffset);
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "org/jetbrains/plugins/groovy/intentions/declaration/GrSetStrongTypeIntention$1", "templateFinished"));
            }
        });
    }

    @Nullable
    private static PsiType getClosureParameterType(@NotNull PsiParameter parameter) {
        PsiElement scope;
        if (parameter == null) {
            GrSetStrongTypeIntention.$$$reportNull$$$0(2);
        }
        PsiType type = (scope = parameter.getDeclarationScope()) instanceof GrClosableBlock ? ClosureParameterEnhancer.inferType((GrClosableBlock)scope, ((GrParameterList)parameter.getParent()).getParameterIndex(parameter)) : null;
        return type;
    }

    @NotNull
    private static TypeInfo getOrCreateTypeElement(@NotNull PsiElement parent, @NotNull PsiElement elementToBuildTemplateOn) {
        int nameElementOffset;
        GrModifierList modifierList;
        if (parent == null) {
            GrSetStrongTypeIntention.$$$reportNull$$$0(3);
        }
        if (elementToBuildTemplateOn == null) {
            GrSetStrongTypeIntention.$$$reportNull$$$0(4);
        }
        if ((modifierList = GrSetStrongTypeIntention.getModifierList(parent)) != null && modifierList.hasModifierProperty("def") && modifierList.getModifiers().length == 1) {
            PsiElement modifier = modifierList.getModifier("def");
            LOG.assertTrue(modifier != null);
            int modifierOffset = modifier.getTextRange().getEndOffset() - elementToBuildTemplateOn.getTextRange().getStartOffset();
            return new TypeInfo(modifier, modifierOffset);
        }
        PsiClassType typeToUse = TypesUtil.createType("Abc", parent);
        if (elementToBuildTemplateOn instanceof GrVariableDeclaration) {
            GrVariableDeclaration decl = (GrVariableDeclaration)elementToBuildTemplateOn;
            decl.setType((PsiType)typeToUse);
            nameElementOffset = decl.getModifierList().getTextRange().getEndOffset() - elementToBuildTemplateOn.getTextRange().getStartOffset();
        } else {
            GrVariable var = (GrVariable)parent;
            var.setType((PsiType)typeToUse);
            nameElementOffset = var.getNameIdentifierGroovy().getTextRange().getStartOffset() - elementToBuildTemplateOn.getTextRange().getStartOffset();
        }
        return new TypeInfo(GrSetStrongTypeIntention.getTypeElement(parent), nameElementOffset);
    }

    @Nullable
    private static GrTypeElement getTypeElement(PsiElement parent) {
        if (parent instanceof GrVariable) {
            return ((GrVariable)parent).getTypeElementGroovy();
        }
        return ((GrVariableDeclaration)parent).getTypeElementGroovy();
    }

    @Nullable
    private static GrModifierList getModifierList(PsiElement parent) {
        GrModifierList modifierList = parent instanceof GrVariable ? ((GrVariable)parent).getModifierList() : ((GrVariableDeclaration)parent).getModifierList();
        return modifierList;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(this){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                PsiElement pparent;
                PsiElement parent;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (2.isNameIdentifierOfVariable(element, parent = element.getParent()) || 2.isModifierListOfVar(element, parent)) {
                    pparent = parent.getParent();
                } else if (2.isModifierListOfVarDecl(element, parent)) {
                    pparent = parent;
                } else {
                    return false;
                }
                if (pparent instanceof GrVariableDeclaration) {
                    GrVariable[] variables;
                    GrVariableDeclaration declaration = (GrVariableDeclaration)pparent;
                    if (declaration.getTypeElementGroovy() != null || declaration.isTuple()) {
                        return false;
                    }
                    for (GrVariable variable : variables = declaration.getVariables()) {
                        if (!GrSetStrongTypeIntention.isVarDeclaredWithInitializer(variable)) continue;
                        return true;
                    }
                } else {
                    if (pparent instanceof GrForInClause) {
                        GrVariable variable = ((GrForInClause)pparent).getDeclaredVariable();
                        return variable != null && variable.getTypeElementGroovy() == null && PsiUtil.extractIteratedType((GrForInClause)pparent) != null;
                    }
                    if (parent instanceof GrParameter && pparent instanceof GrParameterList) {
                        return ((GrParameter)parent).getTypeElementGroovy() == null && GrSetStrongTypeIntention.getClosureParameterType((PsiParameter)parent) != null;
                    }
                    GrVariable variable = (GrVariable)parent;
                    return variable.getTypeElementGroovy() == null && GrSetStrongTypeIntention.isVarDeclaredWithInitializer(variable);
                }
                return false;
            }

            private static boolean isModifierListOfVarDecl(PsiElement element, PsiElement parent) {
                return parent instanceof GrVariableDeclaration && ((GrVariableDeclaration)parent).getModifierList() == element;
            }

            private static boolean isModifierListOfVar(PsiElement element, PsiElement parent) {
                return parent instanceof GrVariable && ((GrVariable)parent).getModifierList() == element;
            }

            private static boolean isNameIdentifierOfVariable(PsiElement element, PsiElement parent) {
                return parent instanceof GrVariable && ((GrVariable)parent).getTypeElementGroovy() == null && element == ((GrVariable)parent).getNameIdentifierGroovy();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/declaration/GrSetStrongTypeIntention$2", "satisfiedBy"));
            }
        };
    }

    private static boolean isVarDeclaredWithInitializer(GrVariable variable) {
        GrExpression initializer = variable.getInitializerGroovy();
        return initializer != null && initializer.getType() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToBuildTemplateOn";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/declaration/GrSetStrongTypeIntention";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getClosureParameterType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrCreateTypeElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TypeInfo {
        final PsiElement elementToReplace;
        final int originalOffset;

        TypeInfo(PsiElement element, int offset) {
            this.originalOffset = offset;
            this.elementToReplace = element;
        }
    }
}

