/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.util.IncorrectOperationException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.GrPsiUpdateIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J \u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/conversions/RemoveParenthesesFromMethodCallIntention;", "Lorg/jetbrains/plugins/groovy/intentions/base/GrPsiUpdateIntention;", "<init>", "()V", "getElementPredicate", "Lorg/jetbrains/plugins/groovy/intentions/base/PsiElementPredicate;", "isStopElement", "", "element", "Lcom/intellij/psi/PsiElement;", "processIntention", "", "context", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "Companion", "Predicate", "intellij.groovy"})
public final class RemoveParenthesesFromMethodCallIntention
extends GrPsiUpdateIntention {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return Predicate.INSTANCE;
    }

    @Override
    protected boolean isStopElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return super.isStopElement(element) || element instanceof GrStatementOwner;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull ActionContext context, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        String newText = RemoveParenthesesFromMethodCallIntention.Companion.removeParentheses((GrMethodCallExpression)element);
        GrStatement grStatement = GroovyPsiElementFactory.getInstance(context.project()).createStatementFromText(newText);
        Intrinsics.checkNotNullExpressionValue((Object)grStatement, (String)"createStatementFromText(...)");
        GrStatement statement = grStatement;
        element.replace((PsiElement)statement);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/conversions/RemoveParenthesesFromMethodCallIntention$Companion;", "", "<init>", "()V", "removeParentheses", "", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrMethodCallExpression;", "replaceWithSpace", "", "Lcom/intellij/lang/ASTNode;", "intellij.groovy"})
    public static final class Companion {
        private Companion() {
        }

        private final String removeParentheses(GrMethodCallExpression call) {
            PsiElement psiElement;
            GrArgumentList grArgumentList;
            PsiElement psiElement2 = call.copy();
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression");
            GrMethodCallExpression copy = (GrMethodCallExpression)psiElement2;
            GrArgumentList $this$removeParentheses_u24lambda_u240 = grArgumentList = copy.getArgumentList();
            boolean bl = false;
            PsiElement psiElement3 = $this$removeParentheses_u24lambda_u240.getLeftParen();
            if (psiElement3 != null && (psiElement3 = psiElement3.getNode()) != null) {
                Companion.replaceWithSpace((ASTNode)psiElement3);
            }
            if ((psiElement = $this$removeParentheses_u24lambda_u240.getRightParen()) != null && (psiElement = psiElement.getNode()) != null) {
                Companion.replaceWithSpace((ASTNode)psiElement);
            }
            String string = copy.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return string;
        }

        private final void replaceWithSpace(ASTNode $this$replaceWithSpace) {
            ASTNode parent = $this$replaceWithSpace.getTreeParent();
            parent.addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", $this$replaceWithSpace);
            parent.removeChild($this$replaceWithSpace);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/conversions/RemoveParenthesesFromMethodCallIntention$Predicate;", "Lorg/jetbrains/plugins/groovy/intentions/base/PsiElementPredicate;", "<init>", "()V", "satisfiedBy", "", "element", "Lcom/intellij/psi/PsiElement;", "checkArguments", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrMethodCallExpression;", "checkPosition", "checkParseableWithoutParentheses", "intellij.groovy"})
    private static final class Predicate
    implements PsiElementPredicate {
        @NotNull
        public static final Predicate INSTANCE = new Predicate();

        private Predicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            GrMethodCallExpression grMethodCallExpression = element instanceof GrMethodCallExpression ? (GrMethodCallExpression)element : null;
            if (grMethodCallExpression == null) {
                return false;
            }
            GrMethodCallExpression call = grMethodCallExpression;
            return this.checkArguments(call) && this.checkPosition(call) && this.checkParseableWithoutParentheses(call);
        }

        private final boolean checkArguments(GrMethodCallExpression call) {
            GrArgumentList grArgumentList = call.getArgumentList();
            Intrinsics.checkNotNullExpressionValue((Object)grArgumentList, (String)"getArgumentList(...)");
            GrArgumentList argumentList = grArgumentList;
            Object[] objectArray = argumentList.getAllArguments();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getAllArguments(...)");
            Object[] arguments2 = objectArray;
            if (call.hasClosureArguments()) {
                return arguments2.length == 0;
            }
            if (arguments2.length == 0) {
                return false;
            }
            if (ArraysKt.first((Object[])arguments2) instanceof GrClosableBlock) {
                return arguments2.length == 1;
            }
            return !(ArraysKt.first((Object[])arguments2) instanceof GrListOrMap);
        }

        private final boolean checkPosition(GrMethodCallExpression call) {
            if (PsiUtil.isExpressionStatement(call)) {
                return true;
            }
            PsiElement parent = call.getParent();
            if (parent instanceof GrVariable && ((GrVariable)parent).getInitializerGroovy() == call) {
                return true;
            }
            return parent instanceof GrAssignmentExpression && ((GrAssignmentExpression)parent).getRValue() == call;
        }

        private final boolean checkParseableWithoutParentheses(GrMethodCallExpression call) {
            String newText = Companion.removeParentheses(call);
            try {
                GroovyPsiElementFactory.getInstance(call.getProject()).createStatementFromText(newText);
            }
            catch (IncorrectOperationException e) {
                return false;
            }
            return true;
        }
    }
}

