/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.time.Month;
import java.time.YearMonth;
import java.time.temporal.Temporal;
import java.util.Arrays;
import org.assertj.core.api.AbstractTemporalAssert;
import org.assertj.core.error.ShouldBeAfter;
import org.assertj.core.error.ShouldBeAfterOrEqualTo;
import org.assertj.core.error.ShouldBeBefore;
import org.assertj.core.error.ShouldBeBeforeOrEqualTo;
import org.assertj.core.error.ShouldBeCurrentYearMonth;
import org.assertj.core.error.ShouldBeInTheFuture;
import org.assertj.core.error.ShouldBeInThePast;
import org.assertj.core.error.ShouldHaveDateField;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Preconditions;

public abstract class AbstractYearMonthAssert<SELF extends AbstractYearMonthAssert<SELF>>
extends AbstractTemporalAssert<SELF, YearMonth> {
    protected AbstractYearMonthAssert(YearMonth actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isBefore(YearMonth other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractYearMonthAssert.assertYearMonthParameterIsNotNull(other);
        if (!((YearMonth)this.actual).isBefore(other)) {
            this.throwAssertionError(ShouldBeBefore.shouldBeBefore(this.actual, other));
        }
        return (SELF)((AbstractYearMonthAssert)this.myself);
    }

    public SELF isBefore(String otherYearMonthAsString) {
        AbstractYearMonthAssert.assertYearMonthAsStringParameterIsNotNull(otherYearMonthAsString);
        return this.isBefore(this.parse(otherYearMonthAsString));
    }

    public SELF isBeforeOrEqualTo(YearMonth other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractYearMonthAssert.assertYearMonthParameterIsNotNull(other);
        if (((YearMonth)this.actual).isAfter(other)) {
            this.throwAssertionError(ShouldBeBeforeOrEqualTo.shouldBeBeforeOrEqualTo(this.actual, other));
        }
        return (SELF)((AbstractYearMonthAssert)this.myself);
    }

    public SELF isBeforeOrEqualTo(String otherYearMonthAsString) {
        AbstractYearMonthAssert.assertYearMonthAsStringParameterIsNotNull(otherYearMonthAsString);
        return this.isBeforeOrEqualTo(this.parse(otherYearMonthAsString));
    }

    public SELF isAfterOrEqualTo(YearMonth other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractYearMonthAssert.assertYearMonthParameterIsNotNull(other);
        if (((YearMonth)this.actual).isBefore(other)) {
            this.throwAssertionError(ShouldBeAfterOrEqualTo.shouldBeAfterOrEqualTo(this.actual, other));
        }
        return (SELF)((AbstractYearMonthAssert)this.myself);
    }

    public SELF isAfterOrEqualTo(String otherYearMonthAsString) {
        AbstractYearMonthAssert.assertYearMonthAsStringParameterIsNotNull(otherYearMonthAsString);
        return this.isAfterOrEqualTo(this.parse(otherYearMonthAsString));
    }

    public SELF isAfter(YearMonth other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractYearMonthAssert.assertYearMonthParameterIsNotNull(other);
        if (!((YearMonth)this.actual).isAfter(other)) {
            this.throwAssertionError(ShouldBeAfter.shouldBeAfter(this.actual, other));
        }
        return (SELF)((AbstractYearMonthAssert)this.myself);
    }

    public SELF isAfter(String otherYearMonthAsString) {
        AbstractYearMonthAssert.assertYearMonthAsStringParameterIsNotNull(otherYearMonthAsString);
        return this.isAfter(this.parse(otherYearMonthAsString));
    }

    public SELF isEqualTo(String otherYearMonthAsString) {
        AbstractYearMonthAssert.assertYearMonthAsStringParameterIsNotNull(otherYearMonthAsString);
        return (SELF)((AbstractYearMonthAssert)this.isEqualTo(this.parse(otherYearMonthAsString)));
    }

    public SELF isNotEqualTo(String otherYearMonthAsString) {
        AbstractYearMonthAssert.assertYearMonthAsStringParameterIsNotNull(otherYearMonthAsString);
        return (SELF)((AbstractYearMonthAssert)this.isNotEqualTo(this.parse(otherYearMonthAsString)));
    }

    public SELF isIn(String ... otherYearMonthsAsString) {
        AbstractYearMonthAssert.checkIsNotNullAndNotEmpty(otherYearMonthsAsString);
        return (SELF)((AbstractYearMonthAssert)this.isIn(AbstractYearMonthAssert.convertToYearMonthArray(otherYearMonthsAsString)));
    }

    public SELF isNotIn(String ... otherYearMonthsAsString) {
        AbstractYearMonthAssert.checkIsNotNullAndNotEmpty(otherYearMonthsAsString);
        return (SELF)((AbstractYearMonthAssert)this.isNotIn(AbstractYearMonthAssert.convertToYearMonthArray(otherYearMonthsAsString)));
    }

    public SELF isInThePast() {
        Objects.instance().assertNotNull(this.info, this.actual);
        if (!((YearMonth)this.actual).isBefore(YearMonth.now())) {
            this.throwAssertionError(ShouldBeInThePast.shouldBeInThePast((Temporal)this.actual));
        }
        return (SELF)((AbstractYearMonthAssert)this.myself);
    }

    public SELF isCurrentYearMonth() {
        Objects.instance().assertNotNull(this.info, this.actual);
        if (!((YearMonth)this.actual).equals(YearMonth.now())) {
            this.throwAssertionError(ShouldBeCurrentYearMonth.shouldBeCurrentYearMonth((YearMonth)this.actual));
        }
        return (SELF)((AbstractYearMonthAssert)this.myself);
    }

    public SELF isInTheFuture() {
        Objects.instance().assertNotNull(this.info, this.actual);
        if (!((YearMonth)this.actual).isAfter(YearMonth.now())) {
            this.throwAssertionError(ShouldBeInTheFuture.shouldBeInTheFuture((Temporal)this.actual));
        }
        return (SELF)((AbstractYearMonthAssert)this.myself);
    }

    public SELF isBetween(YearMonth startInclusive, YearMonth endInclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startInclusive, endInclusive, true, true);
        return (SELF)((AbstractYearMonthAssert)this.myself);
    }

    public SELF isBetween(String startInclusive, String endInclusive) {
        return this.isBetween(this.parse(startInclusive), this.parse(endInclusive));
    }

    public SELF isStrictlyBetween(YearMonth startExclusive, YearMonth endExclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startExclusive, endExclusive, false, false);
        return (SELF)((AbstractYearMonthAssert)this.myself);
    }

    public SELF isStrictlyBetween(String startExclusive, String endExclusive) {
        return this.isStrictlyBetween(this.parse(startExclusive), this.parse(endExclusive));
    }

    public SELF hasYear(int year) {
        Objects.instance().assertNotNull(this.info, this.actual);
        if (((YearMonth)this.actual).getYear() != year) {
            this.throwAssertionError(ShouldHaveDateField.shouldHaveDateField((Temporal)this.actual, "year", year));
        }
        return (SELF)((AbstractYearMonthAssert)this.myself);
    }

    public SELF hasMonth(Month month) {
        Objects.instance().assertNotNull(this.info, this.actual);
        if (!((YearMonth)this.actual).getMonth().equals(month)) {
            this.throwAssertionError(ShouldHaveDateField.shouldHaveMonth((Temporal)this.actual, month));
        }
        return (SELF)((AbstractYearMonthAssert)this.myself);
    }

    public SELF hasMonthValue(int month) {
        Objects.instance().assertNotNull(this.info, this.actual);
        if (((YearMonth)this.actual).getMonthValue() != month) {
            this.throwAssertionError(ShouldHaveDateField.shouldHaveDateField((Temporal)this.actual, "month", month));
        }
        return (SELF)((AbstractYearMonthAssert)this.myself);
    }

    @Override
    protected YearMonth parse(String yearMonthAsString) {
        return YearMonth.parse(yearMonthAsString);
    }

    private static void assertYearMonthParameterIsNotNull(YearMonth other) {
        Preconditions.checkArgument(other != null, "The YearMonth to compare actual with should not be null", new Object[0]);
    }

    private static void assertYearMonthAsStringParameterIsNotNull(String otherYearMonthAsString) {
        Preconditions.checkArgument(otherYearMonthAsString != null, "The String representing the YearMonth to compare actual with should not be null", new Object[0]);
    }

    private static void checkIsNotNullAndNotEmpty(Object[] values) {
        Preconditions.checkArgument(values != null, "The given YearMonth array should not be null", new Object[0]);
        Preconditions.checkArgument(values.length > 0, "The given YearMonth array should not be empty", new Object[0]);
    }

    private static Object[] convertToYearMonthArray(String ... yearMonthsAsString) {
        return Arrays.stream(yearMonthsAsString).map(YearMonth::parse).toArray();
    }
}

