/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.io.BufferedReader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.IdentifierQuotingStrategy;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.OptionsBuilder;
import schemacrawler.schemacrawler.exceptions.InternalRuntimeException;
import us.fatehi.utility.CollectionsUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.ioresource.ClasspathInputResource;

public class IdentifiersBuilder
implements OptionsBuilder<IdentifiersBuilder, Identifiers> {
    private static final Logger LOGGER = Logger.getLogger(Identifiers.class.getName());
    final Collection<String> reservedWords = IdentifiersBuilder.loadSql2003ReservedWords();
    String identifierQuoteString;
    boolean quoteMixedCaseIdentifiers = true;
    IdentifierQuotingStrategy identifierQuotingStrategy = IdentifierQuotingStrategy.quote_if_special_characters_and_reserved_words;

    public static IdentifiersBuilder builder() {
        return new IdentifiersBuilder();
    }

    private static Collection<String> loadSql2003ReservedWords() {
        HashSet<String> reservedWords = new HashSet<String>();
        try (BufferedReader reader = new ClasspathInputResource("/sql2003_reserved_words.txt").openNewInputReader(StandardCharsets.UTF_8);){
            String line;
            while ((line = reader.readLine()) != null) {
                reservedWords.add(line);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not read list of SQL 2003 reserved words", e);
        }
        if (reservedWords.isEmpty()) {
            throw new InternalRuntimeException("No SQL 2003 reserved words found");
        }
        return IdentifiersBuilder.toUpperCase(reservedWords);
    }

    private static Collection<String> lookupReservedWords(DatabaseMetaData metaData) {
        String sqlKeywords = "";
        try {
            sqlKeywords = metaData.getSQLKeywords();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve SQL keywords metadata", e);
        }
        if (Utility.isBlank((String)sqlKeywords)) {
            return Collections.emptyList();
        }
        return IdentifiersBuilder.toUpperCase(Arrays.asList(CollectionsUtility.splitList((String)sqlKeywords)));
    }

    private static Collection<String> toUpperCase(Iterable<String> words) {
        HashSet<String> upperCaseWords = new HashSet<String>();
        if (words != null) {
            for (String word : words) {
                if (Utility.isBlank((String)word)) continue;
                upperCaseWords.add(Utility.trimToEmpty((String)word.toUpperCase()));
            }
        }
        return new ArrayList<String>(upperCaseWords);
    }

    private IdentifiersBuilder() {
    }

    public IdentifiersBuilder doNotQuoteMixedCaseIdentifiers() {
        this.quoteMixedCaseIdentifiers = false;
        return this;
    }

    public IdentifiersBuilder fromConnection(Connection connection) {
        if (connection == null) {
            return this;
        }
        try {
            String metaDataIdentifierQuoteString;
            DatabaseMetaData metaData = Objects.requireNonNull(connection.getMetaData(), "No database metadata obtained");
            this.reservedWords.addAll(IdentifiersBuilder.lookupReservedWords(metaData));
            if (!this.isIdentifierQuoteStringSet() && (metaDataIdentifierQuoteString = metaData.getIdentifierQuoteString()) != null) {
                this.identifierQuoteString = metaDataIdentifierQuoteString;
            }
            this.quoteMixedCaseIdentifiers = !metaData.supportsMixedCaseIdentifiers();
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not obtain connection-specific information", e);
        }
        return this;
    }

    public IdentifiersBuilder fromOptions(Identifiers identifiers) {
        if (identifiers == null) {
            return this;
        }
        this.identifierQuoteString = identifiers.getIdentifierQuoteString();
        this.identifierQuotingStrategy = identifiers.getIdentifierQuotingStrategy();
        this.quoteMixedCaseIdentifiers = identifiers.isQuoteMixedCaseIdentifiers();
        return this;
    }

    public boolean isIdentifierQuoteStringSet() {
        return this.identifierQuoteString != null;
    }

    public IdentifiersBuilder quoteMixedCaseIdentifiers() {
        this.quoteMixedCaseIdentifiers = true;
        return this;
    }

    @Override
    public Identifiers toOptions() {
        return new Identifiers(this);
    }

    public IdentifiersBuilder withIdentifierQuoteString(String identifierQuoteString) {
        this.identifierQuoteString = Utility.isBlank((String)identifierQuoteString) ? "" : identifierQuoteString;
        return this;
    }

    public IdentifiersBuilder withIdentifierQuotingStrategy(IdentifierQuotingStrategy identifierQuotingStrategy) {
        this.identifierQuotingStrategy = identifierQuotingStrategy == null ? IdentifierQuotingStrategy.quote_none : identifierQuotingStrategy;
        return this;
    }
}

