/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.utils.mpp.number;

import ai.grazie.utils.mpp.LoggerFactory;
import ai.grazie.utils.mpp.MPPLogger;
import ai.grazie.utils.mpp.number.FixedPrecisionFloat;
import ai.grazie.utils.mpp.number.FixedPrecisionFloatSerializerKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lai/grazie/utils/mpp/number/FixedPrecisionFloatSerializer;", "Lkotlinx/serialization/KSerializer;", "Lai/grazie/utils/mpp/number/FixedPrecisionFloat;", "<init>", "()V", "logger", "Lai/grazie/utils/mpp/MPPLogger;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "logIfSuspicious", "raw", "", "utils-common"})
public final class FixedPrecisionFloatSerializer
implements KSerializer<FixedPrecisionFloat> {
    @NotNull
    public static final FixedPrecisionFloatSerializer INSTANCE = new FixedPrecisionFloatSerializer();
    @NotNull
    private static final MPPLogger logger = LoggerFactory.INSTANCE.create("ai.grazie.utils.mpp.number.FixedPrecisionFloat");
    @NotNull
    private static final SerialDescriptor descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"FixedPrecisionFloat", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));

    private FixedPrecisionFloatSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull FixedPrecisionFloat value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.logIfSuspicious(value.toString());
        String out = FixedPrecisionFloatSerializerKt.toFixedString(value);
        encoder.encodeString(out);
    }

    @NotNull
    public FixedPrecisionFloat deserialize(@NotNull Decoder decoder) {
        FixedPrecisionFloat fixedPrecisionFloat;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        if (decoder instanceof JsonDecoder) {
            JsonPrimitive primitive = JsonElementKt.getJsonPrimitive((JsonElement)((JsonDecoder)decoder).decodeJsonElement());
            String raw = primitive.getContent();
            this.logIfSuspicious(raw);
            fixedPrecisionFloat = new FixedPrecisionFloat(raw);
        } else {
            String raw = decoder.decodeString();
            this.logIfSuspicious(raw);
            fixedPrecisionFloat = new FixedPrecisionFloat(raw);
        }
        return fixedPrecisionFloat;
    }

    private final void logIfSuspicious(String raw) {
        Regex legacyPattern = new Regex("^-?\\d+\\.-\\d+$");
        if (legacyPattern.matches((CharSequence)raw)) {
            MPPLogger.warning$default(logger, null, () -> FixedPrecisionFloatSerializer.logIfSuspicious$lambda$0(raw), 1, null);
        }
    }

    private static final String logIfSuspicious$lambda$0(String $raw) {
        return "wrong FPF format encountered during serialization/deserialization: '" + $raw + "'";
    }
}

